/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.interfaces.Delegate;
import me.lucko.helper.menu.Gui;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.Slot;
import me.lucko.helper.timings.MCTiming;
import me.lucko.helper.timings.Timings;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SimpleSlot
implements Slot {
    private final Gui gui;
    private final int id;
    protected final Map<ClickType, Set<Consumer<InventoryClickEvent>>> handlers;

    public SimpleSlot(@Nonnull Gui gui, int id) {
        this.gui = gui;
        this.id = id;
        this.handlers = Collections.synchronizedMap(new EnumMap(ClickType.class));
    }

    public void handle(@Nonnull InventoryClickEvent event) {
        Set<Consumer<InventoryClickEvent>> handlers = this.handlers.get(event.getClick());
        if (handlers == null) {
            return;
        }
        for (Consumer<InventoryClickEvent> handler : handlers) {
            try {
                MCTiming t = Timings.ofStart("helper-gui: " + this.getClass().getSimpleName() + " : " + Delegate.resolve(handler).getClass().getName());
                Throwable throwable = null;
                try {
                    handler.accept(event);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (t == null) continue;
                    if (throwable != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    t.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    @Nonnull
    public Gui gui() {
        return this.gui;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Slot applyFromItem(Item item) {
        Objects.requireNonNull(item, "item");
        this.setItem(item.getItemStack());
        this.clearBindings();
        this.bindAllConsumers(item.getHandlers().entrySet());
        return this;
    }

    @Override
    @Nullable
    public ItemStack getItem() {
        return this.gui.getHandle().getItem(this.id);
    }

    @Override
    public boolean hasItem() {
        return this.getItem() != null;
    }

    @Override
    @Nonnull
    public Slot setItem(@Nonnull ItemStack item) {
        Objects.requireNonNull(item, "item");
        this.gui.getHandle().setItem(this.id, item);
        return this;
    }

    @Override
    public Slot clear() {
        this.clearItem();
        this.clearBindings();
        return this;
    }

    @Override
    @Nonnull
    public Slot clearItem() {
        this.gui.getHandle().clear(this.id);
        return this;
    }

    @Override
    @Nonnull
    public Slot clearBindings() {
        this.handlers.clear();
        return this;
    }

    @Override
    @Nonnull
    public Slot clearBindings(ClickType type) {
        this.handlers.remove(type);
        return this;
    }

    @Override
    @Nonnull
    public Slot bind(@Nonnull ClickType type, @Nonnull Consumer<InventoryClickEvent> handler) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(handler, "handler");
        this.handlers.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet()).add(handler);
        return this;
    }

    @Override
    @Nonnull
    public Slot bind(@Nonnull ClickType type, @Nonnull Runnable handler) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(handler, "handler");
        this.handlers.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet()).add(Item.transformRunnable(handler));
        return this;
    }

    @Override
    @Nonnull
    public Slot bind(@Nonnull Consumer<InventoryClickEvent> handler, ClickType ... types) {
        for (ClickType type : types) {
            this.bind(type, handler);
        }
        return this;
    }

    @Override
    @Nonnull
    public Slot bind(@Nonnull Runnable handler, ClickType ... types) {
        for (ClickType type : types) {
            this.bind(type, handler);
        }
        return this;
    }

    @Override
    @Nonnull
    public <T extends Runnable> Slot bindAllRunnables(@Nonnull Iterable<Map.Entry<ClickType, T>> handlers) {
        Objects.requireNonNull(handlers, "handlers");
        for (Map.Entry<ClickType, T> handler : handlers) {
            this.bind(handler.getKey(), (Runnable)handler.getValue());
        }
        return this;
    }

    @Override
    @Nonnull
    public <T extends Consumer<InventoryClickEvent>> Slot bindAllConsumers(@Nonnull Iterable<Map.Entry<ClickType, T>> handlers) {
        Objects.requireNonNull(handlers, "handlers");
        for (Map.Entry<ClickType, T> handler : handlers) {
            this.bind(handler.getKey(), (Consumer)handler.getValue());
        }
        return this;
    }
}

