/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Events;
import me.lucko.helper.Schedulers;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.SimpleSlot;
import me.lucko.helper.menu.Slot;
import me.lucko.helper.metadata.Metadata;
import me.lucko.helper.metadata.MetadataKey;
import me.lucko.helper.metadata.MetadataMap;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import me.lucko.helper.text.Text;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

@NonnullByDefault
public abstract class Gui
implements TerminableConsumer {
    public static final MetadataKey<Gui> OPEN_GUI_KEY = MetadataKey.create("open-gui", Gui.class);
    private final Player player;
    private final Inventory inventory;
    private final String initialTitle;
    private final Map<Integer, SimpleSlot> slots;
    private boolean firstDraw = true;
    @Nullable
    private Function<Player, Gui> fallbackGui = null;
    private final CompositeTerminable compositeTerminable = CompositeTerminable.create();
    private boolean valid = false;

    public static int getMenuSize(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count < 0");
        return Gui.getMenuSize(count, 9);
    }

    public static int getMenuSize(int count, int itemsPerLine) {
        Preconditions.checkArgument((itemsPerLine >= 1 ? 1 : 0) != 0, (Object)"itemsPerLine < 1");
        return count / itemsPerLine + (count % itemsPerLine != 0 ? 1 : 0);
    }

    public Gui(Player player, int lines, String title) {
        this.player = Objects.requireNonNull(player, "player");
        this.initialTitle = Text.colorize(Objects.requireNonNull(title, "title"));
        this.inventory = Bukkit.createInventory((InventoryHolder)player, (int)(lines * 9), (String)this.initialTitle);
        this.slots = new HashMap<Integer, SimpleSlot>();
    }

    public abstract void redraw();

    public Player getPlayer() {
        return this.player;
    }

    public Inventory getHandle() {
        return this.inventory;
    }

    public String getInitialTitle() {
        return this.initialTitle;
    }

    @Nullable
    public Function<Player, Gui> getFallbackGui() {
        return this.fallbackGui;
    }

    public void setFallbackGui(@Nullable Function<Player, Gui> fallbackGui) {
        this.fallbackGui = fallbackGui;
    }

    @Override
    @Nonnull
    public <T extends AutoCloseable> T bind(@Nonnull T terminable) {
        return this.compositeTerminable.bind(terminable);
    }

    public boolean isFirstDraw() {
        return this.firstDraw;
    }

    public Slot getSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.getSize()) {
            throw new IllegalArgumentException("Invalid slot id: " + slot);
        }
        return this.slots.computeIfAbsent(slot, i -> new SimpleSlot(this, (int)i));
    }

    public void setItem(int slot, Item item) {
        this.getSlot(slot).applyFromItem(item);
    }

    public void setItems(Item item, int ... slots) {
        Objects.requireNonNull(item, "item");
        for (int slot : slots) {
            this.setItem(slot, item);
        }
    }

    public void setItems(Iterable<Integer> slots, Item item) {
        Objects.requireNonNull(item, "item");
        Objects.requireNonNull(slots, "slots");
        for (int slot : slots) {
            this.setItem(slot, item);
        }
    }

    public int getFirstEmpty() {
        int ret = this.inventory.firstEmpty();
        if (ret < 0) {
            throw new IndexOutOfBoundsException("no empty slots");
        }
        return ret;
    }

    public Optional<Slot> getFirstEmptySlot() {
        int ret = this.inventory.firstEmpty();
        if (ret < 0) {
            return Optional.empty();
        }
        return Optional.of(this.getSlot(ret));
    }

    public void addItem(Item item) {
        Objects.requireNonNull(item, "item");
        this.getFirstEmptySlot().ifPresent(s -> s.applyFromItem(item));
    }

    public void addItems(Iterable<Item> items) {
        Objects.requireNonNull(items, "items");
        for (Item item : items) {
            this.addItem(item);
        }
    }

    public void fillWith(Item item) {
        Objects.requireNonNull(item, "item");
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            this.setItem(i, item);
        }
    }

    public void removeItem(int slot) {
        this.getSlot(slot).clear();
    }

    public void removeItems(int ... slots) {
        for (int slot : slots) {
            this.removeItem(slot);
        }
    }

    public void removeItems(Iterable<Integer> slots) {
        Objects.requireNonNull(slots, "slots");
        for (int slot : slots) {
            this.removeItem(slot);
        }
    }

    public void clearItems() {
        this.inventory.clear();
        this.slots.values().forEach(Slot::clearBindings);
    }

    public void open() {
        if (this.valid) {
            throw new IllegalStateException("Gui is already opened.");
        }
        this.firstDraw = true;
        try {
            this.redraw();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.invalidate();
            return;
        }
        this.firstDraw = false;
        this.startListening();
        this.player.openInventory(this.inventory);
        Metadata.provideForPlayer(this.player).put(OPEN_GUI_KEY, this);
        this.valid = true;
    }

    public void close() {
        this.player.closeInventory();
    }

    private void invalidate() {
        this.valid = false;
        MetadataMap metadataMap = Metadata.provideForPlayer(this.player);
        Gui existing = metadataMap.getOrNull(OPEN_GUI_KEY);
        if (existing == this) {
            metadataMap.remove(OPEN_GUI_KEY);
        }
        this.compositeTerminable.closeAndReportException();
        this.clearItems();
    }

    public boolean isValid() {
        return this.valid;
    }

    private void startListening() {
        Events.subscribe(InventoryClickEvent.class).filter(e -> e.getInventory().getHolder() != null).filter(e -> e.getInventory().getHolder().equals(this.player)).handler(e -> {
            int slotId;
            e.setCancelled(true);
            if (!this.isValid()) {
                this.close();
            }
            if ((slotId = e.getRawSlot()) != e.getSlot()) {
                return;
            }
            SimpleSlot slot = this.slots.get(slotId);
            if (slot != null) {
                slot.handle((InventoryClickEvent)e);
            }
        }).bindWith(this);
        Events.subscribe(PlayerQuitEvent.class).filter(e -> e.getPlayer().equals(this.player)).filter(e -> this.isValid()).handler(e -> this.invalidate()).bindWith(this);
        Events.subscribe(InventoryCloseEvent.class).filter(e -> e.getPlayer().equals(this.player)).filter(e -> e.getInventory().equals(this.inventory)).filter(e -> this.isValid()).handler(e -> {
            this.invalidate();
            Function<Player, Gui> fallback = this.fallbackGui;
            if (fallback == null) {
                return;
            }
            Schedulers.sync().runLater(() -> {
                if (!this.player.isOnline()) {
                    return;
                }
                ((Gui)fallback.apply(this.player)).open();
            }, 1L);
        }).bindWith(this);
    }
}

