/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.internal;

import me.lucko.helper.Commands;
import me.lucko.helper.bossbar.BossBarFactory;
import me.lucko.helper.bossbar.BukkitBossBarFactory;
import me.lucko.helper.bossbar.ViaBossBarFactory;
import me.lucko.helper.hologram.BukkitHologramFactory;
import me.lucko.helper.hologram.HologramFactory;
import me.lucko.helper.hologram.individual.IndividualHologramFactory;
import me.lucko.helper.hologram.individual.PacketIndividualHologramFactory;
import me.lucko.helper.internal.HelperImplementationPlugin;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.messaging.bungee.BungeeCord;
import me.lucko.helper.messaging.bungee.BungeeCordImpl;
import me.lucko.helper.npc.CitizensNpcFactory;
import me.lucko.helper.npc.NpcFactory;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.scoreboard.PacketScoreboardProvider;
import me.lucko.helper.scoreboard.ScoreboardProvider;
import me.lucko.helper.signprompt.PacketSignPromptFactory;
import me.lucko.helper.signprompt.SignPromptFactory;
import me.lucko.helper.utils.Players;

@HelperImplementationPlugin
public final class StandalonePlugin
extends ExtendedJavaPlugin {
    public StandalonePlugin() {
        this.getLogger().info("Initialized helper v" + this.getDescription().getVersion());
    }

    @Override
    protected void enable() {
        BossBarFactory bossBarFactory;
        Commands.create().handler(c -> {
            Players.msg(c.sender(), new String[]{"&7[&6helper&7] &7Running &6helper v" + this.getDescription().getVersion() + "&7."});
            LoaderUtils.getHelperImplementationPlugins().forEach(pl -> Players.msg(c.sender(), new String[]{"&7[&6helper&7] &7Running &6" + pl.getName() + " v" + pl.getDescription().getVersion() + "&7."}));
        }).register("helper");
        this.provideService(HologramFactory.class, new BukkitHologramFactory());
        this.provideService(BungeeCord.class, new BungeeCordImpl(this));
        if (this.isPluginPresent("ProtocolLib")) {
            PacketScoreboardProvider scoreboardProvider = new PacketScoreboardProvider(this);
            this.provideService(ScoreboardProvider.class, scoreboardProvider);
            this.provideService(PacketScoreboardProvider.class, scoreboardProvider);
            PacketSignPromptFactory signPromptFactory = new PacketSignPromptFactory();
            this.provideService(SignPromptFactory.class, signPromptFactory);
            try {
                PacketIndividualHologramFactory hologramFactory = new PacketIndividualHologramFactory();
                this.provideService(IndividualHologramFactory.class, hologramFactory);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.isPluginPresent("Citizens")) {
            CitizensNpcFactory npcManager = this.bind(new CitizensNpcFactory());
            this.provideService(NpcFactory.class, npcManager);
            this.provideService(CitizensNpcFactory.class, npcManager);
        }
        if (this.isPluginPresent("ViaVersion")) {
            bossBarFactory = new ViaBossBarFactory();
            this.provideService(BossBarFactory.class, bossBarFactory);
        } else if (StandalonePlugin.classExists("org.bukkit.boss.BossBar")) {
            bossBarFactory = new BukkitBossBarFactory(this.getServer());
            this.provideService(BossBarFactory.class, bossBarFactory);
        }
    }

    private static boolean classExists(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

