/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson.typeadapters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import me.lucko.helper.gson.GsonProvider;
import me.lucko.helper.gson.GsonSerializable;

public final class GsonSerializableAdapterFactory
implements TypeAdapterFactory {
    public static final GsonSerializableAdapterFactory INSTANCE = new GsonSerializableAdapterFactory();

    private GsonSerializableAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
        Class clazz = type.getRawType();
        final Method deserializeMethod = GsonSerializable.getDeserializeMethod(clazz);
        if (deserializeMethod == null) {
            return null;
        }
        TypeAdapter<GsonSerializable> typeAdapter = new TypeAdapter<GsonSerializable>(){

            public void write(JsonWriter out, GsonSerializable value) {
                gson.toJson(value.serialize(), out);
            }

            public GsonSerializable read(JsonReader in) throws IOException {
                JsonElement element = GsonProvider.parser().parse(in);
                try {
                    return (GsonSerializable)deserializeMethod.invoke(null, element);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
        return typeAdapter;
    }
}

