/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.function.chain;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.function.chain.SimpleChain;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public interface Chain<T> {
    public static <T> Chain<T> start(@Nullable T object) {
        return new SimpleChain<T>(object);
    }

    public static <T> Chain<T> startOpt(@Nonnull Optional<T> optional) {
        return new SimpleChain<Object>(optional.orElse(null));
    }

    public Chain<T> apply(Consumer<? super T> var1);

    public Chain<T> applyIf(Predicate<? super T> var1, Consumer<? super T> var2);

    public Chain<T> applyIfNonNull(Consumer<? super T> var1);

    public Chain<T> orElse(Predicate<? super T> var1, T var2);

    public Chain<T> orElseIfNull(T var1);

    public Chain<T> orElseGet(Predicate<? super T> var1, Supplier<? extends T> var2);

    public Chain<T> orElseGetIfNull(Supplier<? extends T> var1);

    public <R> Chain<R> ifElse(Predicate<? super T> var1, R var2, R var3);

    public <R> Chain<R> map(Function<? super T, ? extends R> var1);

    public <R> Chain<R> mapOrElse(Predicate<? super T> var1, Function<? super T, ? extends R> var2, R var3);

    public <R> Chain<R> mapOrElse(Predicate<? super T> var1, Function<? super T, ? extends R> var2, Function<? super T, ? extends R> var3);

    public <R> Chain<R> mapNullSafe(Function<? super T, ? extends R> var1, R var2);

    public <R> Chain<R> mapNullSafeGet(Function<? super T, ? extends R> var1, Supplier<? extends R> var2);

    public <R> Chain<R> flatMap(Function<? super T, ? extends Chain<? extends R>> var1);

    public Optional<T> end();

    @Nullable
    public T endOrNull();
}

