/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Types {
    private Types() {
    }

    public static @Nullable String asString(@Nullable Object value) {
        return value == null ? null : value.toString();
    }

    public static @Nullable String strictAsString(@Nullable Object value) {
        return value instanceof String ? (String)value : null;
    }

    public static @Nullable Float asFloat(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Integer) {
            return Float.valueOf(((Number)value).floatValue());
        }
        try {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static @Nullable Float strictAsFloat(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float || value instanceof Integer) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return null;
    }

    public static @Nullable Double asDouble(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Float) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static @Nullable Double strictAsDouble(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Long) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public static @Nullable Integer asInt(@Nullable Object value) {
        double val;
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if ((value instanceof Float || value instanceof Double) && (val = ((Number)value).doubleValue()) == Math.floor(val)) {
            return (int)val;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static @Nullable Integer strictAsInt(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Integer ? (Integer)value : null;
    }

    public static @Nullable Long asLong(@Nullable Object value) {
        double val;
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Number)value).longValue();
        }
        if ((value instanceof Float || value instanceof Double) && (val = ((Number)value).doubleValue()) == Math.floor(val)) {
            return (long)val;
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static @Nullable Long strictAsLong(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Number)value).longValue();
        }
        return null;
    }

    public static @Nullable Boolean asBoolean(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return !value.equals(0);
        }
        String potential = value.toString();
        if (potential.equals("true") || potential.equals("t") || potential.equals("yes") || potential.equals("y") || potential.equals("1")) {
            return true;
        }
        if (potential.equals("false") || potential.equals("f") || potential.equals("no") || potential.equals("n") || potential.equals("0")) {
            return false;
        }
        return null;
    }

    public static @Nullable Boolean strictAsBoolean(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Boolean ? (Boolean)value : null;
    }

    public static @Nullable Date asDate(Object value) {
        TemporalAccessor temp;
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof TemporalAccessor && (temp = (TemporalAccessor)value).isSupported(ChronoField.INSTANT_SECONDS)) {
            long millis = temp.get(ChronoField.INSTANT_SECONDS) * 1000;
            if (temp.isSupported(ChronoField.MILLI_OF_SECOND)) {
                millis += (long)temp.get(ChronoField.MILLI_OF_SECOND);
            }
            return new Date(millis);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String dateString = value.toString();
        try {
            return DateFormat.getInstance().parse(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static @Nullable Date strictAsDate(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Date ? (Date)value : null;
    }

    public static @Nullable Instant asInstant(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Date) {
            return Instant.ofEpochMilli(((Date)value).getTime());
        }
        if (value instanceof TemporalAccessor) {
            try {
                return Instant.from((TemporalAccessor)value);
            }
            catch (DateTimeException ex) {
                return null;
            }
        }
        String dateString = value.toString();
        try {
            return Instant.parse(dateString);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static @Nullable Instant strictAsInstant(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Instant ? (Instant)value : null;
    }
}

