/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.bossbar;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.lucko.helper.bossbar.BossBar;
import me.lucko.helper.bossbar.BossBarColor;
import me.lucko.helper.bossbar.BossBarFactory;
import me.lucko.helper.bossbar.BossBarStyle;
import me.lucko.helper.text.Text;
import me.lucko.helper.utils.ImmutableCollectors;
import me.lucko.helper.utils.Players;
import org.bukkit.entity.Player;
import us.myles.ViaVersion.api.Via;
import us.myles.ViaVersion.api.boss.BossColor;
import us.myles.ViaVersion.api.boss.BossStyle;

public class ViaBossBarFactory
implements BossBarFactory {
    @Override
    @Nonnull
    public BossBar newBossBar() {
        return new ViaBossBar(Via.getAPI().createBossBar("null", ViaBossBarFactory.convertColor(BossBarColor.defaultColor()), ViaBossBarFactory.convertStyle(BossBarStyle.defaultStyle())));
    }

    private static BossBarStyle convertStyle(BossStyle style) {
        switch (style) {
            case SOLID: {
                return BossBarStyle.SOLID;
            }
            case SEGMENTED_6: {
                return BossBarStyle.SEGMENTED_6;
            }
            case SEGMENTED_10: {
                return BossBarStyle.SEGMENTED_10;
            }
            case SEGMENTED_12: {
                return BossBarStyle.SEGMENTED_12;
            }
            case SEGMENTED_20: {
                return BossBarStyle.SEGMENTED_20;
            }
        }
        return BossBarStyle.defaultStyle();
    }

    private static BossStyle convertStyle(BossBarStyle style) {
        switch (style) {
            case SOLID: {
                return BossStyle.SOLID;
            }
            case SEGMENTED_6: {
                return BossStyle.SEGMENTED_6;
            }
            case SEGMENTED_10: {
                return BossStyle.SEGMENTED_10;
            }
            case SEGMENTED_12: {
                return BossStyle.SEGMENTED_12;
            }
            case SEGMENTED_20: {
                return BossStyle.SEGMENTED_20;
            }
        }
        return ViaBossBarFactory.convertStyle(BossBarStyle.defaultStyle());
    }

    private static BossBarColor convertColor(BossColor color) {
        switch (color) {
            case PINK: {
                return BossBarColor.PINK;
            }
            case BLUE: {
                return BossBarColor.BLUE;
            }
            case RED: {
                return BossBarColor.RED;
            }
            case GREEN: {
                return BossBarColor.GREEN;
            }
            case YELLOW: {
                return BossBarColor.YELLOW;
            }
            case PURPLE: {
                return BossBarColor.PURPLE;
            }
            case WHITE: {
                return BossBarColor.WHITE;
            }
        }
        return BossBarColor.defaultColor();
    }

    private static BossColor convertColor(BossBarColor color) {
        switch (color) {
            case PINK: {
                return BossColor.PINK;
            }
            case BLUE: {
                return BossColor.BLUE;
            }
            case RED: {
                return BossColor.RED;
            }
            case GREEN: {
                return BossColor.GREEN;
            }
            case YELLOW: {
                return BossColor.YELLOW;
            }
            case PURPLE: {
                return BossColor.PURPLE;
            }
            case WHITE: {
                return BossColor.WHITE;
            }
        }
        return ViaBossBarFactory.convertColor(BossBarColor.defaultColor());
    }

    private static class ViaBossBar
    implements BossBar {
        private final us.myles.ViaVersion.api.boss.BossBar<?> bar;

        ViaBossBar(us.myles.ViaVersion.api.boss.BossBar<?> bar) {
            this.bar = bar;
        }

        @Override
        @Nonnull
        public String title() {
            return this.bar.getTitle();
        }

        @Override
        @Nonnull
        public BossBar title(@Nonnull String title) {
            this.bar.setTitle(Text.colorize(title));
            return this;
        }

        @Override
        public double progress() {
            return this.bar.getHealth();
        }

        @Override
        @Nonnull
        public BossBar progress(double progress) {
            this.bar.setHealth((float)progress);
            return this;
        }

        @Override
        @Nonnull
        public BossBarColor color() {
            return ViaBossBarFactory.convertColor(this.bar.getColor());
        }

        @Override
        @Nonnull
        public BossBar color(@Nonnull BossBarColor color) {
            this.bar.setColor(ViaBossBarFactory.convertColor(color));
            return this;
        }

        @Override
        @Nonnull
        public BossBarStyle style() {
            return ViaBossBarFactory.convertStyle(this.bar.getStyle());
        }

        @Override
        @Nonnull
        public BossBar style(@Nonnull BossBarStyle style) {
            this.bar.setStyle(ViaBossBarFactory.convertStyle(style));
            return this;
        }

        @Override
        public boolean visible() {
            return this.bar.isVisible();
        }

        @Override
        @Nonnull
        public BossBar visible(boolean visible) {
            if (visible) {
                this.bar.show();
            } else {
                this.bar.hide();
            }
            return this;
        }

        @Override
        @Nonnull
        public List<Player> players() {
            return (List)this.bar.getPlayers().stream().map(Players::getNullable).filter(Objects::nonNull).collect(ImmutableCollectors.toList());
        }

        @Override
        public void addPlayer(@Nonnull Player player) {
            this.bar.addPlayer(player.getUniqueId());
        }

        @Override
        public void removePlayer(@Nonnull Player player) {
            this.bar.removePlayer(player.getUniqueId());
        }

        @Override
        public void removeAll() {
            for (UUID player : this.bar.getPlayers()) {
                this.bar.removePlayer(player);
            }
        }

        @Override
        public void close() {
            this.removeAll();
        }
    }
}

