/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.text.AbstractBuildableComponent;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.event.ClickEvent;
import me.lucko.helper.text.event.HoverEvent;
import me.lucko.helper.text.format.TextColor;
import me.lucko.helper.text.format.TextDecoration;
import net.kyori.blizzard.NonNull;
import net.kyori.blizzard.Nullable;

public class TextComponent
extends AbstractBuildableComponent<TextComponent, Builder> {
    @NonNull
    private final String content;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull String content) {
        return new Builder().content(content);
    }

    public static TextComponent of(@NonNull String content) {
        return TextComponent.builder(content).build();
    }

    protected TextComponent(@NonNull Builder builder) {
        super(builder);
        this.content = builder.content;
    }

    protected TextComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @NonNull String content) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
        this.content = content;
    }

    @NonNull
    public String content() {
        return this.content;
    }

    @NonNull
    public TextComponent content(@NonNull String content) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, (String)Preconditions.checkNotNull((Object)content, (Object)"content"));
    }

    @Override
    @NonNull
    public TextComponent append(@NonNull Component component) {
        this.detectCycle(component);
        ArrayList<Component> children = new ArrayList<Component>(this.children.size() + 1);
        children.addAll(this.children);
        children.add(component);
        return new TextComponent(children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    @NonNull
    public TextComponent color(@Nullable TextColor color) {
        return new TextComponent(this.children, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    @NonNull
    public TextComponent decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (TextComponent)super.decoration(decoration, flag);
    }

    @Override
    @NonNull
    public TextComponent decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new TextComponent(this.children, this.color, this.obfuscated, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case ITALIC: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case UNDERLINE: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case STRIKETHROUGH: {
                return new TextComponent(this.children, this.color, this.obfuscated, this.bold, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
            case OBFUSCATED: {
                return new TextComponent(this.children, this.color, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    @NonNull
    public TextComponent clickEvent(@Nullable ClickEvent event) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    @NonNull
    public TextComponent hoverEvent(@Nullable HoverEvent event) {
        if (event != null) {
            this.detectCycle(event.value());
        }
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion, this.content);
    }

    @Override
    @NonNull
    public TextComponent insertion(@Nullable String insertion) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion, this.content);
    }

    @Override
    @NonNull
    public TextComponent mergeStyle(@NonNull Component that) {
        return new TextComponent(this.children, that.color(), that.decoration(TextDecoration.OBFUSCATED), that.decoration(TextDecoration.BOLD), that.decoration(TextDecoration.STRIKETHROUGH), that.decoration(TextDecoration.UNDERLINE), that.decoration(TextDecoration.ITALIC), that.clickEvent(), that.hoverEvent(), that.insertion(), this.content);
    }

    @Override
    @NonNull
    public TextComponent mergeColor(@NonNull Component that) {
        return new TextComponent(this.children, that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    @NonNull
    public TextComponent mergeDecorations(@NonNull Component that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINE) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINE) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new TextComponent(this.children, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    @NonNull
    public TextComponent mergeEvents(@NonNull Component that) {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion, this.content);
    }

    @Override
    @NonNull
    public TextComponent resetStyle() {
        return new TextComponent(this.children, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null, this.content);
    }

    @Override
    @NonNull
    public TextComponent copy() {
        return new TextComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.content);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof TextComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TextComponent component = (TextComponent)other;
        return Objects.equal((Object)this.content, (Object)component.content);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.content});
    }

    @Override
    protected void populateToString(@NonNull Objects.ToStringHelper builder) {
        builder.add("content", (Object)this.content);
    }

    @Override
    @NonNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractBuildableComponent.AbstractBuilder<TextComponent, Builder> {
        @Nullable
        private String content;

        Builder() {
        }

        Builder(@NonNull TextComponent component) {
            super(component);
            this.content = component.content();
        }

        @NonNull
        public Builder content(@NonNull String content) {
            this.content = content;
            return this;
        }

        @Override
        @NonNull
        public TextComponent build() {
            Preconditions.checkState((this.content != null ? 1 : 0) != 0, (Object)"content must be set");
            return new TextComponent(this);
        }
    }
}

