/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.helper.text.BukkitTextUtils;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.TextComponent;
import me.lucko.helper.text.serializer.ComponentSerializers;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public final class Text {
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';

    public static String joinNewline(String ... strings) {
        return Text.joinNewline(Arrays.stream(strings));
    }

    public static String joinNewline(Stream<String> strings) {
        return strings.collect(Collectors.joining("\n"));
    }

    public static TextComponent fromLegacy(String input, char character) {
        return ComponentSerializers.LEGACY.deserialize(input, character);
    }

    public static TextComponent fromLegacy(String input) {
        return ComponentSerializers.LEGACY.deserialize(input);
    }

    public static String toLegacy(Component component, char character) {
        return ComponentSerializers.LEGACY.serialize(component, character);
    }

    public static String toLegacy(Component component) {
        return ComponentSerializers.LEGACY.serialize(component);
    }

    public static void sendMessage(CommandSender sender, Component message) {
        BukkitTextUtils.sendJsonMessage(sender, message);
    }

    public static void sendMessage(Iterable<CommandSender> senders, Component message) {
        BukkitTextUtils.sendJsonMessage(senders, message);
    }

    public static String colorize(String s) {
        return s == null ? null : ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    private Text() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

