/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.text.AbstractBuildableComponent;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.event.ClickEvent;
import me.lucko.helper.text.event.HoverEvent;
import me.lucko.helper.text.format.TextColor;
import me.lucko.helper.text.format.TextDecoration;
import net.kyori.blizzard.NonNull;
import net.kyori.blizzard.Nullable;

public class SelectorComponent
extends AbstractBuildableComponent<SelectorComponent, Builder> {
    @NonNull
    private final String pattern;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull String pattern) {
        return new Builder().pattern(pattern);
    }

    public static SelectorComponent of(@NonNull String pattern) {
        return SelectorComponent.builder(pattern).build();
    }

    protected SelectorComponent(@NonNull Builder builder) {
        super(builder);
        this.pattern = builder.pattern;
    }

    protected SelectorComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @NonNull String pattern) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
        this.pattern = pattern;
    }

    @NonNull
    public String pattern() {
        return this.pattern;
    }

    @NonNull
    public SelectorComponent pattern(@NonNull String pattern) {
        return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, (String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern"));
    }

    @Override
    @NonNull
    public SelectorComponent append(@NonNull Component component) {
        this.detectCycle(component);
        ArrayList<Component> children = new ArrayList<Component>(this.children.size() + 1);
        children.addAll(this.children);
        children.add(component);
        return new SelectorComponent(children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent color(@Nullable TextColor color) {
        return new SelectorComponent(this.children, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (SelectorComponent)super.decoration(decoration, flag);
    }

    @Override
    @NonNull
    public SelectorComponent decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new SelectorComponent(this.children, this.color, this.obfuscated, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
            }
            case ITALIC: {
                return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
            }
            case UNDERLINE: {
                return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
            }
            case STRIKETHROUGH: {
                return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
            }
            case OBFUSCATED: {
                return new SelectorComponent(this.children, this.color, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    @NonNull
    public SelectorComponent clickEvent(@Nullable ClickEvent event) {
        return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent hoverEvent(@Nullable HoverEvent event) {
        if (event != null) {
            this.detectCycle(event.value());
        }
        return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent insertion(@Nullable String insertion) {
        return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent mergeStyle(@NonNull Component that) {
        return new SelectorComponent(this.children, that.color(), that.decoration(TextDecoration.OBFUSCATED), that.decoration(TextDecoration.BOLD), that.decoration(TextDecoration.STRIKETHROUGH), that.decoration(TextDecoration.UNDERLINE), that.decoration(TextDecoration.ITALIC), that.clickEvent(), that.hoverEvent(), that.insertion(), this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent mergeColor(@NonNull Component that) {
        return new SelectorComponent(this.children, that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent mergeDecorations(@NonNull Component that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINE) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINE) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new SelectorComponent(this.children, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent mergeEvents(@NonNull Component that) {
        return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent resetStyle() {
        return new SelectorComponent(this.children, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null, this.pattern);
    }

    @Override
    @NonNull
    public SelectorComponent copy() {
        return new SelectorComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.pattern);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof SelectorComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        SelectorComponent that = (SelectorComponent)other;
        return Objects.equal((Object)this.pattern, (Object)that.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.pattern});
    }

    @Override
    protected void populateToString(@NonNull Objects.ToStringHelper builder) {
        builder.add("pattern", (Object)this.pattern);
    }

    @Override
    @NonNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractBuildableComponent.AbstractBuilder<SelectorComponent, Builder> {
        @Nullable
        private String pattern;

        Builder() {
        }

        Builder(@NonNull SelectorComponent component) {
            super(component);
            this.pattern = component.pattern();
        }

        @NonNull
        public Builder pattern(@NonNull String pattern) {
            this.pattern = pattern;
            return this;
        }

        @Override
        @NonNull
        public SelectorComponent build() {
            Preconditions.checkState((this.pattern != null ? 1 : 0) != 0, (Object)"pattern must be set");
            return new SelectorComponent(this);
        }
    }
}

