/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.lucko.helper.text.TextComponent;
import me.lucko.helper.text.event.ClickEvent;
import me.lucko.helper.text.event.HoverEvent;
import me.lucko.helper.text.format.TextColor;
import me.lucko.helper.text.format.TextDecoration;
import net.kyori.blizzard.NonNull;
import net.kyori.blizzard.Nullable;

public interface Component {
    public static final List<Component> EMPTY_COMPONENT_LIST = Collections.emptyList();

    @NonNull
    public List<Component> children();

    default public boolean contains(@NonNull Component that) {
        if (this == that) {
            return true;
        }
        for (Component child : this.children()) {
            if (!child.contains(that)) continue;
            return true;
        }
        if (this.hoverEvent() != null) {
            Component hover = this.hoverEvent().value();
            if (that == hover) {
                return true;
            }
            for (Component child : hover.children()) {
                if (!child.contains(that)) continue;
                return true;
            }
        }
        return false;
    }

    default public void detectCycle(@NonNull Component that) {
        if (that.contains(this)) {
            throw new IllegalStateException("Component cycle detected between " + this + " and " + that);
        }
    }

    @NonNull
    public Component append(@NonNull Component var1);

    @NonNull
    public Component copy();

    @Nullable
    public TextColor color();

    @NonNull
    public Component color(@Nullable TextColor var1);

    default public boolean hasDecoration(@NonNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    @NonNull
    public TextDecoration.State decoration(@NonNull TextDecoration var1);

    @NonNull
    default public Component decoration(@NonNull TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    @NonNull
    public Component decoration(@NonNull TextDecoration var1, @NonNull TextDecoration.State var2);

    @NonNull
    default public Set<TextDecoration> decorations() {
        return this.decorations(Collections.emptySet());
    }

    @NonNull
    default public Set<TextDecoration> decorations(@NonNull Set<TextDecoration> defaultValues) {
        EnumSet<TextDecoration> decorations = EnumSet.noneOf(TextDecoration.class);
        for (TextDecoration decoration : TextDecoration.values()) {
            TextDecoration.State value = this.decoration(decoration);
            if (value != TextDecoration.State.TRUE && (value != TextDecoration.State.NOT_SET || !defaultValues.contains(decoration))) continue;
            decorations.add(decoration);
        }
        return decorations;
    }

    @Nullable
    public ClickEvent clickEvent();

    @NonNull
    public Component clickEvent(@Nullable ClickEvent var1);

    @Nullable
    public HoverEvent hoverEvent();

    @NonNull
    public Component hoverEvent(@Nullable HoverEvent var1);

    @Nullable
    public String insertion();

    @NonNull
    public Component insertion(@Nullable String var1);

    @NonNull
    public Component mergeStyle(@NonNull Component var1);

    @NonNull
    public Component mergeColor(@NonNull Component var1);

    @NonNull
    public Component mergeDecorations(@NonNull Component var1);

    @NonNull
    public Component mergeEvents(@NonNull Component var1);

    @NonNull
    public Component resetStyle();

    public boolean hasStyling();

    @NonNull
    public static Component of(boolean value) {
        return TextComponent.of(String.valueOf(value));
    }

    @NonNull
    public static Component of(char value) {
        return TextComponent.of(String.valueOf(value));
    }

    @NonNull
    public static Component of(double value) {
        return TextComponent.of(String.valueOf(value));
    }

    @NonNull
    public static Component of(float value) {
        return TextComponent.of(String.valueOf(value));
    }

    @NonNull
    public static Component of(int value) {
        return TextComponent.of(String.valueOf(value));
    }

    @NonNull
    public static Component of(long value) {
        return TextComponent.of(String.valueOf(value));
    }
}

