/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.terminable.composite;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import me.lucko.helper.terminable.Terminable;
import me.lucko.helper.terminable.composite.CompositeClosingException;
import me.lucko.helper.terminable.composite.CompositeTerminable;

public class AbstractCompositeTerminable
implements CompositeTerminable {
    private final Deque<AutoCloseable> closeables = new ConcurrentLinkedDeque<AutoCloseable>();

    protected AbstractCompositeTerminable() {
    }

    @Override
    public CompositeTerminable with(AutoCloseable autoCloseable) {
        Objects.requireNonNull(autoCloseable, "autoCloseable");
        this.closeables.push(autoCloseable);
        return this;
    }

    @Override
    public void close() throws CompositeClosingException {
        AutoCloseable ac;
        ArrayList<Exception> caught = new ArrayList<Exception>();
        while ((ac = this.closeables.poll()) != null) {
            try {
                ac.close();
            }
            catch (Exception e) {
                caught.add(e);
            }
        }
        if (!caught.isEmpty()) {
            throw new CompositeClosingException(caught);
        }
    }

    @Override
    public void cleanup() {
        this.closeables.removeIf(ac -> ac instanceof Terminable && ((Terminable)ac).isClosed());
    }
}

