/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.serialize;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Helper;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.serialize.BlockPosition;
import me.lucko.helper.serialize.Direction;
import me.lucko.helper.serialize.Point;
import me.lucko.helper.serialize.Region;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public final class Position
implements GsonSerializable {
    private final double x;
    private final double y;
    private final double z;
    private final String world;
    @Nullable
    private Location bukkitLocation = null;

    public static Position deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument((boolean)object.has("x"));
        Preconditions.checkArgument((boolean)object.has("y"));
        Preconditions.checkArgument((boolean)object.has("z"));
        Preconditions.checkArgument((boolean)object.has("world"));
        double x = object.get("x").getAsDouble();
        double y = object.get("y").getAsDouble();
        double z = object.get("z").getAsDouble();
        String world = object.get("world").getAsString();
        return Position.of(x, y, z, world);
    }

    public static Position of(double x, double y, double z, String world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return new Position(x, y, z, world);
    }

    public static Position of(double x, double y, double z, World world) {
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return Position.of(x, y, z, world.getName());
    }

    public static Position of(Vector3d vector, String world) {
        Preconditions.checkNotNull((Object)vector, (Object)"vector");
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return Position.of(vector.getX(), vector.getY(), vector.getZ(), world);
    }

    public static Position of(Vector3d vector, World world) {
        Preconditions.checkNotNull((Object)vector, (Object)"vector");
        Preconditions.checkNotNull((Object)world, (Object)"world");
        return Position.of(vector.getX(), vector.getY(), vector.getZ(), world);
    }

    public static Position of(Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"location");
        return Position.of(location.getX(), location.getY(), location.getZ(), location.getWorld().getName());
    }

    public static Position of(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block");
        return Position.of(block.getLocation());
    }

    private Position(double x, double y, double z, String world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getWorld() {
        return this.world;
    }

    public Vector3d toVector() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public synchronized Location toLocation() {
        if (this.bukkitLocation == null) {
            this.bukkitLocation = new Location(Helper.worldNullable(this.world), this.x, this.y, this.z);
        }
        return this.bukkitLocation.clone();
    }

    public BlockPosition floor() {
        return BlockPosition.of(Position.bukkitFloor(this.x), Position.bukkitFloor(this.y), Position.bukkitFloor(this.z), this.world);
    }

    public Position getRelative(BlockFace face) {
        Preconditions.checkNotNull((Object)face, (Object)"face");
        return Position.of(this.x + (double)face.getModX(), this.y + (double)face.getModY(), this.z + (double)face.getModZ(), this.world);
    }

    public Position getRelative(BlockFace face, double distance) {
        Preconditions.checkNotNull((Object)face, (Object)"face");
        return Position.of(this.x + (double)face.getModX() * distance, this.y + (double)face.getModY() * distance, this.z + (double)face.getModZ() * distance, this.world);
    }

    public Position add(Vector3i vector3i) {
        return this.add(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public Position add(Vector3d vector3d) {
        return this.add(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    public Position add(double x, double y, double z) {
        return Position.of(this.x + x, this.y + y, this.z + z, this.world);
    }

    public Position subtract(Vector3i vector3i) {
        return this.subtract(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public Position subtract(Vector3d vector3d) {
        return this.subtract(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    public Position subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public Region regionWith(Position other) {
        Preconditions.checkNotNull((Object)other, (Object)"other");
        return Region.of(this, other);
    }

    public Point withDirection(Direction direction) {
        return Point.of(this, direction);
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("x", this.x).add("y", this.y).add("z", this.z).add("world", this.world).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        return Double.compare(this.getX(), other.getX()) == 0 && Double.compare(this.getY(), other.getY()) == 0 && Double.compare(this.getZ(), other.getZ()) == 0 && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long x = Double.doubleToLongBits(this.getX());
        long y = Double.doubleToLongBits(this.getY());
        long z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)(x >>> 32 ^ x);
        result = result * 59 + (int)(y >>> 32 ^ y);
        result = result * 59 + (int)(z >>> 32 ^ z);
        result = result * 59 + this.getWorld().hashCode();
        return result;
    }

    public String toString() {
        return "Position(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", world=" + this.getWorld() + ")";
    }

    private static int bukkitFloor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }
}

