/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scoreboard;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.lucko.helper.scoreboard.PacketScoreboard;
import me.lucko.helper.scoreboard.ScoreboardTeam;
import me.lucko.helper.text.Text;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

@NonnullByDefault
public class PacketScoreboardTeam
implements ScoreboardTeam {
    private static final int MAX_NAME_LENGTH = 32;
    private static final int MAX_PREFIX_SUFFIX_LENGTH = 16;
    private static final int MAX_TEAM_MEMBER_LENGTH = 40;
    private final PacketScoreboard scoreboard;
    private final String id;
    private boolean autoSubscribe;
    private final Set<String> players = Collections.synchronizedSet(new HashSet());
    private final Set<Player> subscribed = Collections.synchronizedSet(new HashSet());
    private String displayName;
    private String prefix = "";
    private String suffix = "";
    private boolean allowFriendlyFire = true;
    private boolean canSeeFriendlyInvisibles = true;
    private ScoreboardTeam.NameTagVisibility nameTagVisibility = ScoreboardTeam.NameTagVisibility.ALWAYS;
    private ScoreboardTeam.CollisionRule collisionRule = ScoreboardTeam.CollisionRule.ALWAYS;
    private ChatColor color = ChatColor.RESET;
    private static final Map<ChatColor, Integer> COLOR_CODES;

    private static String trimName(String name) {
        return name.length() > 32 ? name.substring(0, 32) : name;
    }

    private static String trimPrefixSuffix(String name) {
        return name.length() > 16 ? name.substring(0, 16) : name;
    }

    private static String trimMember(String name) {
        return name.length() > 40 ? name.substring(0, 40) : name;
    }

    public PacketScoreboardTeam(PacketScoreboard scoreboard, String id, String displayName, boolean autoSubscribe) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkArgument((id.length() <= 16 ? 1 : 0) != 0, (Object)"id cannot be longer than 16 characters");
        this.scoreboard = (PacketScoreboard)Preconditions.checkNotNull((Object)scoreboard, (Object)"scoreboard");
        this.id = id;
        this.displayName = PacketScoreboardTeam.trimName(Text.colorize((String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName")));
        this.autoSubscribe = autoSubscribe;
    }

    public PacketScoreboardTeam(PacketScoreboard scoreboard, String id, String displayName) {
        this(scoreboard, id, displayName, true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean shouldAutoSubscribe() {
        return this.autoSubscribe;
    }

    @Override
    public void setAutoSubscribe(boolean autoSubscribe) {
        this.autoSubscribe = autoSubscribe;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
        displayName = PacketScoreboardTeam.trimName(Text.colorize(displayName));
        if (this.displayName.equals(displayName)) {
            return;
        }
        this.displayName = displayName;
        this.scoreboard.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
        prefix = PacketScoreboardTeam.trimPrefixSuffix(Text.colorize(prefix));
        if (this.prefix.equals(prefix)) {
            return;
        }
        this.prefix = prefix;
        this.scoreboard.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void setSuffix(String suffix) {
        Preconditions.checkNotNull((Object)suffix, (Object)"suffix");
        suffix = PacketScoreboardTeam.trimPrefixSuffix(Text.colorize(suffix));
        if (this.suffix.equals(suffix)) {
            return;
        }
        this.suffix = suffix;
        this.scoreboard.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public boolean isAllowFriendlyFire() {
        return this.allowFriendlyFire;
    }

    @Override
    public void setAllowFriendlyFire(boolean allowFriendlyFire) {
        if (this.allowFriendlyFire == allowFriendlyFire) {
            return;
        }
        this.allowFriendlyFire = allowFriendlyFire;
        this.scoreboard.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public boolean isCanSeeFriendlyInvisibles() {
        return this.canSeeFriendlyInvisibles;
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean canSeeFriendlyInvisibles) {
        if (this.canSeeFriendlyInvisibles == canSeeFriendlyInvisibles) {
            return;
        }
        this.canSeeFriendlyInvisibles = canSeeFriendlyInvisibles;
        this.scoreboard.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public ScoreboardTeam.NameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    public void setNameTagVisibility(ScoreboardTeam.NameTagVisibility nameTagVisibility) {
        Preconditions.checkNotNull((Object)((Object)nameTagVisibility), (Object)"nameTagVisibility");
        if (this.nameTagVisibility == nameTagVisibility) {
            return;
        }
        this.nameTagVisibility = nameTagVisibility;
        this.scoreboard.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public ScoreboardTeam.CollisionRule getCollisionRule() {
        return this.collisionRule;
    }

    @Override
    public void setCollisionRule(ScoreboardTeam.CollisionRule collisionRule) {
        Preconditions.checkNotNull((Object)((Object)collisionRule), (Object)"collisionRule");
        if (this.collisionRule == collisionRule) {
            return;
        }
        this.collisionRule = collisionRule;
        this.scoreboard.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public ChatColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(ChatColor color) {
        Preconditions.checkNotNull((Object)color, (Object)"color");
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.scoreboard.broadcastPacket(this.subscribed, this.newUpdatePacket());
    }

    @Override
    public boolean addPlayer(String player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        player = PacketScoreboardTeam.trimMember(player);
        if (!this.players.add(player)) {
            return false;
        }
        this.scoreboard.broadcastPacket(this.subscribed, this.newTeamMemberUpdatePacket(player, MemberAction.ADD));
        return true;
    }

    @Override
    public boolean removePlayer(String player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        player = PacketScoreboardTeam.trimMember(player);
        if (!this.players.remove(player)) {
            return false;
        }
        this.scoreboard.broadcastPacket(this.subscribed, this.newTeamMemberUpdatePacket(player, MemberAction.REMOVE));
        return true;
    }

    @Override
    public boolean hasPlayer(String player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        return this.players.contains(PacketScoreboardTeam.trimMember(player));
    }

    @Override
    public Set<String> getPlayers() {
        return ImmutableSet.copyOf(this.players);
    }

    @Override
    public void subscribe(Player player) {
        this.scoreboard.sendPacket(this.newCreatePacket(), player);
        this.subscribed.add(player);
    }

    @Override
    public void unsubscribe(Player player) {
        this.unsubscribe(player, false);
    }

    @Override
    public void unsubscribe(Player player, boolean fast) {
        if (!this.subscribed.remove(player) || fast) {
            return;
        }
        this.scoreboard.sendPacket(this.newRemovePacket(), player);
    }

    @Override
    public void unsubscribeAll() {
        this.scoreboard.broadcastPacket(this.subscribed, this.newRemovePacket());
        this.subscribed.clear();
    }

    private PacketContainer newCreatePacket() {
        PacketContainer packet = this.newUpdatePacket();
        packet.getIntegers().write(1, (Object)UpdateType.CREATE.getCode());
        ArrayList<String> players = new ArrayList<String>(this.getPlayers());
        packet.getSpecificModifier(Collection.class).write(0, players);
        return packet;
    }

    private PacketContainer newRemovePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)this.getId());
        packet.getIntegers().write(1, (Object)UpdateType.REMOVE.getCode());
        return packet;
    }

    private PacketContainer newUpdatePacket() {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)this.getId());
        packet.getIntegers().write(1, (Object)UpdateType.UPDATE.getCode());
        packet.getStrings().write(1, (Object)this.getDisplayName());
        packet.getStrings().write(2, (Object)this.getPrefix());
        packet.getStrings().write(3, (Object)this.getSuffix());
        int data = 0;
        if (this.isAllowFriendlyFire()) {
            data |= 1;
        }
        if (this.isCanSeeFriendlyInvisibles()) {
            data |= 2;
        }
        packet.getIntegers().write(2, (Object)data);
        packet.getStrings().write(4, (Object)this.getNameTagVisibility().getProtocolName());
        packet.getStrings().write(5, (Object)this.getCollisionRule().getProtocolName());
        packet.getIntegers().write(0, (Object)COLOR_CODES.getOrDefault(this.getColor(), -1));
        return packet;
    }

    private PacketContainer newTeamMemberUpdatePacket(String player, MemberAction action) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)this.getId());
        switch (action) {
            case ADD: {
                packet.getIntegers().write(1, (Object)UpdateType.ADD_PLAYERS.getCode());
                break;
            }
            case REMOVE: {
                packet.getIntegers().write(1, (Object)UpdateType.REMOVE_PLAYERS.getCode());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        packet.getSpecificModifier(Collection.class).write(0, Collections.singletonList(player));
        return packet;
    }

    static {
        EnumMap<ChatColor, Integer> codes = new EnumMap<ChatColor, Integer>(ChatColor.class);
        try {
            Field codeField = ChatColor.class.getDeclaredField("intCode");
            codeField.setAccessible(true);
            for (ChatColor color : ChatColor.values()) {
                if (!color.isColor()) continue;
                codes.put(color, codeField.getInt(color));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        COLOR_CODES = codes;
    }

    private static enum UpdateType {
        CREATE(0),
        REMOVE(1),
        UPDATE(2),
        ADD_PLAYERS(3),
        REMOVE_PLAYERS(4);

        private final int code;

        private UpdateType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    private static enum MemberAction {
        ADD,
        REMOVE;

    }
}

