/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scoreboard;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import me.lucko.helper.scoreboard.PacketScoreboard;
import me.lucko.helper.scoreboard.ScoreboardObjective;
import me.lucko.helper.text.Text;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;

@NonnullByDefault
public class PacketScoreboardObjective
implements ScoreboardObjective {
    private static final int MAX_SCORE_LENGTH = 40;
    private static final int MAX_NAME_LENGTH = 32;
    private final PacketScoreboard scoreboard;
    private final String id;
    private boolean autoSubscribe;
    private final Map<String, Integer> scores = Collections.synchronizedMap(new HashMap());
    private final Set<Player> subscribed = Collections.synchronizedSet(new HashSet());
    private String displayName;
    private DisplaySlot displaySlot;

    private static String trimScore(String name) {
        return name.length() > 40 ? name.substring(0, 40) : name;
    }

    private static String trimName(String name) {
        return name.length() > 32 ? name.substring(0, 32) : name;
    }

    public PacketScoreboardObjective(PacketScoreboard scoreboard, String id, String displayName, DisplaySlot displaySlot, boolean autoSubscribe) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkArgument((id.length() <= 16 ? 1 : 0) != 0, (Object)"id cannot be longer than 16 characters");
        this.scoreboard = (PacketScoreboard)Preconditions.checkNotNull((Object)scoreboard, (Object)"scoreboard");
        this.id = id;
        this.displayName = PacketScoreboardObjective.trimName(Text.colorize((String)Preconditions.checkNotNull((Object)displayName, (Object)"displayName")));
        this.displaySlot = (DisplaySlot)Preconditions.checkNotNull((Object)displaySlot, (Object)"displaySlot");
        this.autoSubscribe = autoSubscribe;
    }

    public PacketScoreboardObjective(PacketScoreboard scoreboard, String id, String displayName, DisplaySlot displaySlot) {
        this(scoreboard, id, displayName, displaySlot, true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean shouldAutoSubscribe() {
        return this.autoSubscribe;
    }

    @Override
    public void setAutoSubscribe(boolean autoSubscribe) {
        this.autoSubscribe = autoSubscribe;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        Preconditions.checkNotNull((Object)displayName, (Object)"displayName");
        displayName = PacketScoreboardObjective.trimName(Text.colorize(displayName));
        if (this.displayName.equals(displayName)) {
            return;
        }
        this.displayName = displayName;
        this.scoreboard.broadcastPacket(this.subscribed, this.newObjectivePacket(UpdateType.UPDATE));
    }

    @Override
    public DisplaySlot getDisplaySlot() {
        return this.displaySlot;
    }

    @Override
    public void setDisplaySlot(DisplaySlot displaySlot) {
        Preconditions.checkNotNull((Object)displaySlot, (Object)"displaySlot");
        if (this.displaySlot == displaySlot) {
            return;
        }
        this.displaySlot = displaySlot;
        this.scoreboard.broadcastPacket(this.subscribed, this.newDisplaySlotPacket(displaySlot));
    }

    @Override
    public Map<String, Integer> getScores() {
        return ImmutableMap.copyOf(this.scores);
    }

    @Override
    public boolean hasScore(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.scores.containsKey(PacketScoreboardObjective.trimScore(Text.colorize(name)));
    }

    @Override
    @Nullable
    public Integer getScore(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return this.scores.get(PacketScoreboardObjective.trimScore(Text.colorize(name)));
    }

    @Override
    public void setScore(String name, int value) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        name = PacketScoreboardObjective.trimScore(Text.colorize(name));
        Integer oldValue = this.scores.put(name, value);
        if (oldValue != null && oldValue == value) {
            return;
        }
        this.scoreboard.broadcastPacket(this.subscribed, this.newScorePacket(name, value, EnumWrappers.ScoreboardAction.CHANGE));
    }

    @Override
    public boolean removeScore(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        name = PacketScoreboardObjective.trimScore(Text.colorize(name));
        if (this.scores.remove(name) == null) {
            return false;
        }
        this.scoreboard.broadcastPacket(this.subscribed, this.newScorePacket(name, 0, EnumWrappers.ScoreboardAction.REMOVE));
        return true;
    }

    @Override
    public void clearScores() {
        this.scores.clear();
        this.scoreboard.broadcastPacket(this.subscribed, this.newObjectivePacket(UpdateType.REMOVE));
        for (Player player : this.subscribed) {
            this.subscribe(player);
        }
    }

    @Override
    public void applyScores(Map<String, Integer> scores) {
        Preconditions.checkNotNull(scores, (Object)"scores");
        HashSet<String> toRemove = new HashSet<String>(this.getScores().keySet());
        for (Map.Entry<String, Integer> score : scores.entrySet()) {
            toRemove.remove(PacketScoreboardObjective.trimScore(Text.colorize(score.getKey())));
        }
        for (String name : toRemove) {
            this.removeScore(name);
        }
        for (Map.Entry<String, Integer> score : scores.entrySet()) {
            this.setScore(score.getKey(), score.getValue());
        }
    }

    @Override
    public void applyLines(String ... lines) {
        this.applyLines(Arrays.asList(lines));
    }

    @Override
    public void applyLines(Collection<String> lines) {
        Preconditions.checkNotNull(lines, (Object)"lines");
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        int i = lines.size();
        for (String line : lines) {
            scores.put(line, i--);
        }
        this.applyScores(scores);
    }

    @Override
    public void subscribe(Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        this.scoreboard.sendPacket(this.newObjectivePacket(UpdateType.CREATE), player);
        this.scoreboard.sendPacket(this.newDisplaySlotPacket(this.getDisplaySlot()), player);
        for (Map.Entry<String, Integer> score : this.getScores().entrySet()) {
            this.scoreboard.sendPacket(this.newScorePacket(score.getKey(), score.getValue(), EnumWrappers.ScoreboardAction.CHANGE), player);
        }
        this.subscribed.add(player);
    }

    @Override
    public void unsubscribe(Player player) {
        this.unsubscribe(player, false);
    }

    @Override
    public void unsubscribe(Player player, boolean fast) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (!this.subscribed.remove(player) || fast) {
            return;
        }
        this.scoreboard.sendPacket(this.newObjectivePacket(UpdateType.REMOVE), player);
    }

    @Override
    public void unsubscribeAll() {
        this.scoreboard.broadcastPacket(this.subscribed, this.newObjectivePacket(UpdateType.REMOVE));
        this.subscribed.clear();
    }

    private PacketContainer newObjectivePacket(UpdateType mode) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        packet.getStrings().write(0, (Object)this.getId());
        packet.getIntegers().write(0, (Object)mode.getCode());
        packet.getStrings().write(1, (Object)this.getDisplayName());
        packet.getEnumModifier(HealthDisplay.class, 2).write(0, (Object)HealthDisplay.INTEGER);
        return packet;
    }

    private PacketContainer newScorePacket(String name, int value, EnumWrappers.ScoreboardAction action) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
        packet.getStrings().write(0, (Object)name);
        packet.getScoreboardActions().write(0, (Object)action);
        packet.getStrings().write(1, (Object)this.getId());
        packet.getIntegers().write(0, (Object)value);
        return packet;
    }

    private PacketContainer newDisplaySlotPacket(DisplaySlot displaySlot) {
        int slot;
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_DISPLAY_OBJECTIVE);
        switch (displaySlot) {
            case PLAYER_LIST: {
                slot = 0;
                break;
            }
            case SIDEBAR: {
                slot = 1;
                break;
            }
            case BELOW_NAME: {
                slot = 2;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        packet.getIntegers().write(0, (Object)slot);
        packet.getStrings().write(0, (Object)this.getId());
        return packet;
    }

    private static enum HealthDisplay {
        INTEGER,
        HEARTS;

    }

    private static enum UpdateType {
        CREATE(0),
        REMOVE(1),
        UPDATE(2);

        private final int code;

        private UpdateType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

