/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scheduler.builder;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.lucko.helper.Schedulers;
import me.lucko.helper.promise.ThreadContext;
import me.lucko.helper.scheduler.Task;
import me.lucko.helper.scheduler.builder.ContextualTaskBuilder;

class ContextualTaskBuilderImpl
implements ContextualTaskBuilder {
    private final ThreadContext context;
    private final long delay;
    private final long interval;

    ContextualTaskBuilderImpl(ThreadContext context, long delay, long interval) {
        this.context = context;
        this.delay = delay;
        this.interval = interval;
    }

    @Override
    @Nonnull
    public Task consume(@Nonnull Consumer<Task> consumer) {
        return Schedulers.get(this.context).runRepeating(consumer, this.delay, this.interval);
    }

    @Override
    @Nonnull
    public Task run(@Nonnull Runnable runnable) {
        return Schedulers.get(this.context).runRepeating(runnable, this.delay, this.interval);
    }
}

