/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scheduler.builder;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.lucko.helper.Schedulers;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.promise.ThreadContext;
import me.lucko.helper.scheduler.builder.ContextualPromiseBuilder;

class ContextualPromiseBuilderImpl
implements ContextualPromiseBuilder {
    private final ThreadContext context;

    ContextualPromiseBuilderImpl(ThreadContext context) {
        this.context = context;
    }

    @Override
    @Nonnull
    public <T> Promise<T> supply(@Nonnull Supplier<T> supplier) {
        return Schedulers.get(this.context).supply(supplier);
    }

    @Override
    @Nonnull
    public <T> Promise<T> call(@Nonnull Callable<T> callable) {
        return Schedulers.get(this.context).call(callable);
    }

    @Override
    @Nonnull
    public Promise<Void> run(@Nonnull Runnable runnable) {
        return Schedulers.get(this.context).run(runnable);
    }
}

