/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.lucko.helper.interfaces.Delegate;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.timings.MCTiming;
import me.lucko.helper.timings.Timings;
import me.lucko.helper.utils.Log;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class HelperExecutors {
    private static final Consumer<Throwable> EXCEPTION_CONSUMER = throwable -> {
        Log.severe("[SCHEDULER] Exception thrown whilst executing task");
        throwable.printStackTrace();
    };
    private static final Executor SYNC_BUKKIT = new BukkitSyncExecutor();
    private static final Executor ASYNC_BUKKIT = new BukkitAsyncExecutor();
    private static final Executor ASYNC_HELPER = new HelperAsyncExecutor();

    public static Executor sync() {
        return SYNC_BUKKIT;
    }

    public static Executor asyncHelper() {
        return ASYNC_HELPER;
    }

    public static Executor asyncBukkit() {
        return ASYNC_BUKKIT;
    }

    public static Runnable wrapRunnable(Runnable runnable) {
        return new SchedulerWrappedRunnable(runnable);
    }

    private HelperExecutors() {
    }

    private static final class SchedulerWrappedRunnable
    implements Runnable,
    Delegate<Runnable> {
        private final Runnable delegate;

        private SchedulerWrappedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try (MCTiming t = Timings.ofStart("helper-scheduler: " + Delegate.resolve(this.delegate).getClass().getName());){
                this.delegate.run();
            }
            catch (Throwable t2) {
                EXCEPTION_CONSUMER.accept(t2);
            }
        }

        @Override
        public Runnable getDelegate() {
            return this.delegate;
        }
    }

    private static final class HelperAsyncExecutor
    extends ThreadPoolExecutor {
        private HelperAsyncExecutor() {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("helper-scheduler-%d").build());
        }

        @Override
        public void execute(Runnable runnable) {
            super.execute(HelperExecutors.wrapRunnable(runnable));
        }
    }

    private static final class BukkitAsyncExecutor
    implements Executor {
        private BukkitAsyncExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)LoaderUtils.getPlugin(), HelperExecutors.wrapRunnable(runnable));
        }
    }

    private static final class BukkitSyncExecutor
    implements Executor {
        private BukkitSyncExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LoaderUtils.getPlugin(), HelperExecutors.wrapRunnable(runnable));
        }
    }
}

