/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.reflect;

import javax.annotation.Nonnull;
import org.bukkit.Bukkit;

public final class ServerReflection {
    public static final String NMS = "net.minecraft.server";
    public static final String OBC = "org.bukkit.craftbukkit";
    private static final String SERVER_VERSION;
    private static final String SERVER_VERSION_PACKAGE_COMPONENT;
    private static final String VERSIONED_NMS;
    private static final String VERSIONED_OBC;

    @Nonnull
    public static String getServerVersion() {
        return SERVER_VERSION;
    }

    @Nonnull
    public static String nms(String className) {
        return VERSIONED_NMS + className;
    }

    @Nonnull
    public static Class<?> nmsClass(String className) throws ClassNotFoundException {
        return Class.forName(ServerReflection.nms(className));
    }

    @Nonnull
    public static String obc(String className) {
        return VERSIONED_OBC + className;
    }

    @Nonnull
    public static Class<?> obcClass(String className) throws ClassNotFoundException {
        return Class.forName(ServerReflection.obc(className));
    }

    private ServerReflection() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    static {
        String obcPackage;
        String serverVersion = "";
        Class<?> server = Bukkit.getServer().getClass();
        if (server.getSimpleName().equals("CraftServer") && !server.getName().equals("org.bukkit.craftbukkit.CraftServer") && (obcPackage = server.getPackage().getName()).startsWith("org.bukkit.craftbukkit.")) {
            serverVersion = obcPackage.substring("org.bukkit.craftbukkit.".length());
        }
        SERVER_VERSION_PACKAGE_COMPONENT = (SERVER_VERSION = serverVersion).isEmpty() ? "." : "." + SERVER_VERSION + ".";
        VERSIONED_NMS = NMS + SERVER_VERSION_PACKAGE_COMPONENT;
        VERSIONED_OBC = OBC + SERVER_VERSION_PACKAGE_COMPONENT;
    }
}

