/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.random;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Stream;
import me.lucko.helper.random.RandomSelector;
import me.lucko.helper.random.Weigher;

final class RandomSelectorImpl<E>
implements RandomSelector<E> {
    private final E[] elements;
    private final IndexSelector selection;

    static <E> RandomSelector<E> uniform(Collection<E> elements) {
        Preconditions.checkNotNull(elements, (Object)"elements must not be null");
        Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0, (Object)"elements must not be empty");
        int size = elements.size();
        Object[] array = elements.toArray(new Object[size]);
        return new RandomSelectorImpl<Object>(array, new BoundedRandomSelector(size));
    }

    static <E> RandomSelector<E> weighted(Collection<E> elements, Weigher<? super E> weigher) {
        int i;
        Preconditions.checkNotNull(elements, (Object)"elements must not be null");
        Preconditions.checkNotNull(weigher, (Object)"weigher must not be null");
        Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0, (Object)"elements must not be empty");
        int size = elements.size();
        Object[] elementArray = elements.toArray(new Object[size]);
        double totalWeight = 0.0;
        double[] probabilities = new double[size];
        for (i = 0; i < size; ++i) {
            double weight = weigher.weigh(elementArray[i]);
            Preconditions.checkArgument((weight > 0.0 ? 1 : 0) != 0, (Object)"weigher returned a negative number");
            probabilities[i] = weight;
            totalWeight += weight;
        }
        i = 0;
        while (i < size) {
            int n = i++;
            probabilities[n] = probabilities[n] / totalWeight;
        }
        return new RandomSelectorImpl<Object>(elementArray, new WeightedSelector(probabilities));
    }

    private RandomSelectorImpl(E[] elements, IndexSelector selection) {
        this.elements = elements;
        this.selection = selection;
    }

    @Override
    public E pick(Random random) {
        return this.elements[this.selection.pickIndex(random)];
    }

    @Override
    public Stream<E> stream(Random random) {
        Preconditions.checkNotNull((Object)random, (Object)"random must not be null");
        return Stream.generate(() -> this.pick(random));
    }

    private static final class WeightedSelector
    implements IndexSelector {
        private final double[] probabilities;
        private final int[] alias;

        WeightedSelector(double[] probabilities) {
            int size = probabilities.length;
            double average = 1.0 / (double)size;
            int[] small = new int[size];
            int smallSize = 0;
            int[] large = new int[size];
            int largeSize = 0;
            for (int i = 0; i < size; ++i) {
                if (probabilities[i] < average) {
                    small[smallSize++] = i;
                    continue;
                }
                large[largeSize++] = i;
            }
            double[] pr = new double[size];
            int[] al = new int[size];
            this.probabilities = pr;
            this.alias = al;
            while (largeSize != 0 && smallSize != 0) {
                int less = small[--smallSize];
                int more = large[--largeSize];
                pr[less] = probabilities[less] * (double)size;
                al[less] = more;
                int n = more;
                probabilities[n] = probabilities[n] + (probabilities[less] - average);
                if (probabilities[more] < average) {
                    small[smallSize++] = more;
                    continue;
                }
                large[largeSize++] = more;
            }
            while (smallSize != 0) {
                pr[small[--smallSize]] = 1.0;
            }
            while (largeSize != 0) {
                pr[large[--largeSize]] = 1.0;
            }
        }

        @Override
        public int pickIndex(Random random) {
            int column = random.nextInt(this.probabilities.length);
            return random.nextDouble() < this.probabilities[column] ? column : this.alias[column];
        }
    }

    private static final class BoundedRandomSelector
    implements IndexSelector {
        private final int bound;

        private BoundedRandomSelector(int bound) {
            this.bound = bound;
        }

        @Override
        public int pickIndex(Random random) {
            return random.nextInt(this.bound);
        }
    }

    private static interface IndexSelector {
        public int pickIndex(Random var1);
    }
}

