/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.promise;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.promise.HelperPromise;
import me.lucko.helper.promise.ThreadContext;
import me.lucko.helper.terminable.Terminable;
import me.lucko.helper.utils.Delegates;

public interface Promise<V>
extends Future<V>,
Terminable {
    @Nonnull
    public static <U> Promise<U> empty() {
        return HelperPromise.empty();
    }

    public static Promise<Void> start() {
        return HelperPromise.completed(null);
    }

    @Nonnull
    public static <U> Promise<U> completed(@Nullable U value) {
        return HelperPromise.completed(value);
    }

    public static <U> Promise<U> exceptionally(@Nonnull Throwable exception) {
        return HelperPromise.exceptionally(exception);
    }

    @Nonnull
    public static <U> Promise<U> supplying(@Nonnull ThreadContext context, @Nonnull Supplier<U> supplier) {
        Promise<U> p = Promise.empty();
        return p.supply(context, supplier);
    }

    @Nonnull
    public static <U> Promise<U> supplyingSync(@Nonnull Supplier<U> supplier) {
        Promise<U> p = Promise.empty();
        return p.supplySync(supplier);
    }

    @Nonnull
    public static <U> Promise<U> supplyingAsync(@Nonnull Supplier<U> supplier) {
        Promise<U> p = Promise.empty();
        return p.supplyAsync(supplier);
    }

    @Nonnull
    public static <U> Promise<U> supplyingDelayed(@Nonnull ThreadContext context, @Nonnull Supplier<U> supplier, long delay) {
        Promise<U> p = Promise.empty();
        return p.supplyDelayed(context, supplier, delay);
    }

    @Nonnull
    public static <U> Promise<U> supplyingDelayedSync(@Nonnull Supplier<U> supplier, long delay) {
        Promise<U> p = Promise.empty();
        return p.supplyDelayedSync(supplier, delay);
    }

    @Nonnull
    public static <U> Promise<U> supplyingDelayedAsync(@Nonnull Supplier<U> supplier, long delay) {
        Promise<U> p = Promise.empty();
        return p.supplyDelayedAsync(supplier, delay);
    }

    default public boolean cancel() {
        return this.cancel(true);
    }

    public V join();

    public V getNow(V var1);

    @Nonnull
    public Promise<V> supply(@Nullable V var1);

    @Nonnull
    public Promise<V> supplyException(@Nonnull Throwable var1);

    @Nonnull
    default public Promise<V> supply(@Nonnull ThreadContext context, @Nonnull Supplier<V> supplier) {
        switch (context) {
            case SYNC: {
                return this.supplySync(supplier);
            }
            case ASYNC: {
                return this.supplyAsync(supplier);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public Promise<V> supplySync(@Nonnull Supplier<V> var1);

    @Nonnull
    public Promise<V> supplyAsync(@Nonnull Supplier<V> var1);

    @Nonnull
    default public Promise<V> supplyDelayed(@Nonnull ThreadContext context, @Nonnull Supplier<V> supplier, long delay) {
        switch (context) {
            case SYNC: {
                return this.supplyDelayedSync(supplier, delay);
            }
            case ASYNC: {
                return this.supplyDelayedAsync(supplier, delay);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public Promise<V> supplyDelayedSync(@Nonnull Supplier<V> var1, long var2);

    @Nonnull
    public Promise<V> supplyDelayedAsync(@Nonnull Supplier<V> var1, long var2);

    @Nonnull
    default public <U> Promise<U> thenApply(@Nonnull ThreadContext context, @Nonnull Function<? super V, ? extends U> fn) {
        switch (context) {
            case SYNC: {
                return this.thenApplySync(fn);
            }
            case ASYNC: {
                return this.thenApplyAsync(fn);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public <U> Promise<U> thenApplySync(@Nonnull Function<? super V, ? extends U> var1);

    @Nonnull
    public <U> Promise<U> thenApplyAsync(@Nonnull Function<? super V, ? extends U> var1);

    @Nonnull
    default public <U> Promise<U> thenApplyDelayed(@Nonnull ThreadContext context, @Nonnull Function<? super V, ? extends U> fn, long delay) {
        switch (context) {
            case SYNC: {
                return this.thenApplyDelayedSync(fn, delay);
            }
            case ASYNC: {
                return this.thenApplyDelayedAsync(fn, delay);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public <U> Promise<U> thenApplyDelayedSync(@Nonnull Function<? super V, ? extends U> var1, long var2);

    @Nonnull
    public <U> Promise<U> thenApplyDelayedAsync(@Nonnull Function<? super V, ? extends U> var1, long var2);

    @Nonnull
    default public Promise<Void> thenAccept(@Nonnull ThreadContext context, @Nonnull Consumer<? super V> action) {
        switch (context) {
            case SYNC: {
                return this.thenAcceptSync(action);
            }
            case ASYNC: {
                return this.thenAcceptAsync(action);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    default public Promise<Void> thenAcceptSync(@Nonnull Consumer<? super V> action) {
        return this.thenApplySync(Delegates.consumerToFunction(action));
    }

    @Nonnull
    default public Promise<Void> thenAcceptAsync(@Nonnull Consumer<? super V> action) {
        return this.thenApplyAsync(Delegates.consumerToFunction(action));
    }

    @Nonnull
    default public Promise<Void> thenAcceptDelayed(@Nonnull ThreadContext context, @Nonnull Consumer<? super V> action, long delay) {
        switch (context) {
            case SYNC: {
                return this.thenAcceptDelayedSync(action, delay);
            }
            case ASYNC: {
                return this.thenAcceptDelayedAsync(action, delay);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    default public Promise<Void> thenAcceptDelayedSync(@Nonnull Consumer<? super V> action, long delay) {
        return this.thenApplyDelayedSync(Delegates.consumerToFunction(action), delay);
    }

    @Nonnull
    default public Promise<Void> thenAcceptDelayedAsync(@Nonnull Consumer<? super V> action, long delay) {
        return this.thenApplyDelayedAsync(Delegates.consumerToFunction(action), delay);
    }

    @Nonnull
    default public Promise<Void> thenRun(@Nonnull ThreadContext context, @Nonnull Runnable action) {
        switch (context) {
            case SYNC: {
                return this.thenRunSync(action);
            }
            case ASYNC: {
                return this.thenRunAsync(action);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    default public Promise<Void> thenRunSync(@Nonnull Runnable action) {
        return this.thenApplySync(Delegates.runnableToFunction(action));
    }

    @Nonnull
    default public Promise<Void> thenRunAsync(@Nonnull Runnable action) {
        return this.thenApplyAsync(Delegates.runnableToFunction(action));
    }

    @Nonnull
    default public Promise<Void> thenRunDelayed(@Nonnull ThreadContext context, @Nonnull Runnable action, long delay) {
        switch (context) {
            case SYNC: {
                return this.thenRunDelayedSync(action, delay);
            }
            case ASYNC: {
                return this.thenRunDelayedAsync(action, delay);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    default public Promise<Void> thenRunDelayedSync(@Nonnull Runnable action, long delay) {
        return this.thenApplyDelayedSync(Delegates.runnableToFunction(action), delay);
    }

    @Nonnull
    default public Promise<Void> thenRunDelayedAsync(@Nonnull Runnable action, long delay) {
        return this.thenApplyDelayedAsync(Delegates.runnableToFunction(action), delay);
    }

    @Nonnull
    default public <U> Promise<U> thenCompose(@Nonnull ThreadContext context, @Nonnull Function<? super V, ? extends Promise<U>> fn) {
        switch (context) {
            case SYNC: {
                return this.thenComposeSync(fn);
            }
            case ASYNC: {
                return this.thenComposeAsync(fn);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public <U> Promise<U> thenComposeSync(@Nonnull Function<? super V, ? extends Promise<U>> var1);

    @Nonnull
    public <U> Promise<U> thenComposeAsync(@Nonnull Function<? super V, ? extends Promise<U>> var1);

    @Nonnull
    default public <U> Promise<U> thenComposeDelayedSync(@Nonnull ThreadContext context, @Nonnull Function<? super V, ? extends Promise<U>> fn, long delay) {
        switch (context) {
            case SYNC: {
                return this.thenComposeDelayedSync(fn, delay);
            }
            case ASYNC: {
                return this.thenComposeDelayedAsync(fn, delay);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public <U> Promise<U> thenComposeDelayedSync(@Nonnull Function<? super V, ? extends Promise<U>> var1, long var2);

    @Nonnull
    public <U> Promise<U> thenComposeDelayedAsync(@Nonnull Function<? super V, ? extends Promise<U>> var1, long var2);

    @Nonnull
    default public Promise<V> exceptionally(@Nonnull ThreadContext context, @Nonnull Function<Throwable, ? extends V> fn) {
        switch (context) {
            case SYNC: {
                return this.exceptionallySync(fn);
            }
            case ASYNC: {
                return this.exceptionallySync(fn);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public Promise<V> exceptionallySync(@Nonnull Function<Throwable, ? extends V> var1);

    @Nonnull
    public Promise<V> exceptionallyAsync(@Nonnull Function<Throwable, ? extends V> var1);

    @Nonnull
    default public Promise<V> exceptionallyDelayed(@Nonnull ThreadContext context, @Nonnull Function<Throwable, ? extends V> fn, long delay) {
        switch (context) {
            case SYNC: {
                return this.exceptionallyDelayedSync(fn, delay);
            }
            case ASYNC: {
                return this.exceptionallyDelayedAsync(fn, delay);
            }
        }
        throw new AssertionError();
    }

    @Nonnull
    public Promise<V> exceptionallyDelayedSync(@Nonnull Function<Throwable, ? extends V> var1, long var2);

    @Nonnull
    public Promise<V> exceptionallyDelayedAsync(@Nonnull Function<Throwable, ? extends V> var1, long var2);

    public CompletableFuture<V> toCompletableFuture();
}

