/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.plugin;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Schedulers;
import me.lucko.helper.config.Configs;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.maven.LibraryLoader;
import me.lucko.helper.plugin.HelperPlugin;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import me.lucko.helper.terminable.module.TerminableModule;
import me.lucko.helper.utils.CommandMapUtil;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class ExtendedJavaPlugin
extends JavaPlugin
implements HelperPlugin {
    private CompositeTerminable terminableRegistry;

    protected void load() {
    }

    protected void enable() {
    }

    protected void disable() {
    }

    public final void onLoad() {
        LoaderUtils.getPlugin();
        this.terminableRegistry = CompositeTerminable.create();
        LibraryLoader.loadAll(this.getClass());
        this.load();
    }

    public final void onEnable() {
        Schedulers.builder().async().after(10L, TimeUnit.SECONDS).every(30L, TimeUnit.SECONDS).run(this.terminableRegistry::cleanup).bindWith(this.terminableRegistry);
        this.enable();
    }

    public final void onDisable() {
        this.disable();
        this.terminableRegistry.closeAndReportException();
    }

    @Override
    @Nonnull
    public <T extends AutoCloseable> T bind(@Nonnull T terminable) {
        return this.terminableRegistry.bind(terminable);
    }

    @Override
    @Nonnull
    public <T extends TerminableModule> T bindModule(@Nonnull T module) {
        return this.terminableRegistry.bindModule(module);
    }

    @Override
    @Nonnull
    public <T extends Listener> T registerListener(@Nonnull T listener) {
        Preconditions.checkNotNull(listener, (Object)"listener");
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        return listener;
    }

    @Override
    @Nonnull
    public <T extends CommandExecutor> T registerCommand(@Nonnull T command, String ... aliases) {
        return CommandMapUtil.registerCommand(this, command, aliases);
    }

    @Override
    @Nullable
    public <T> T getService(@Nonnull Class<T> service) {
        return (T)this.getServer().getServicesManager().load(service);
    }

    @Override
    @Nonnull
    public <T> T provideService(@Nonnull Class<T> clazz, @Nonnull T instance, @Nonnull ServicePriority priority) {
        this.getServer().getServicesManager().register(clazz, instance, (Plugin)this, priority);
        return instance;
    }

    @Override
    @Nonnull
    public <T> T provideService(@Nonnull Class<T> clazz, @Nonnull T instance) {
        Preconditions.checkNotNull(clazz, (Object)"clazz");
        Preconditions.checkNotNull(instance, (Object)"instance");
        return this.provideService(clazz, instance, ServicePriority.Normal);
    }

    @Override
    @Nullable
    public <T> T getPlugin(@Nonnull String name, @Nonnull Class<T> pluginClass) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(pluginClass, (Object)"pluginClass");
        return (T)this.getServer().getPluginManager().getPlugin(name);
    }

    @Override
    @Nonnull
    public File getBundledFile(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.getDataFolder().mkdirs();
        File file = new File(this.getDataFolder(), name);
        if (!file.exists()) {
            this.saveResource(name, false);
        }
        return file;
    }

    @Override
    @Nonnull
    public YamlConfiguration loadConfig(@Nonnull String file) {
        Preconditions.checkNotNull((Object)file, (Object)"file");
        return YamlConfiguration.loadConfiguration((File)this.getBundledFile(file));
    }

    @Override
    @Nonnull
    public ConfigurationNode loadConfigNode(@Nonnull String file) {
        Preconditions.checkNotNull((Object)file, (Object)"file");
        return Configs.yamlLoad(this.getBundledFile(file));
    }

    @Override
    @Nonnull
    public ClassLoader getClassloader() {
        return super.getClassLoader();
    }
}

