/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.metadata;

import com.google.common.base.Preconditions;
import java.lang.ref.SoftReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.lucko.helper.metadata.TransientValue;

public final class SoftValue<T>
implements TransientValue<T> {
    private final SoftReference<T> value;

    public static <T> SoftValue<T> of(T value) {
        Preconditions.checkNotNull(value, (Object)"value");
        return new SoftValue<T>(value);
    }

    public static <T> Supplier<SoftValue<T>> supplied(Supplier<? extends T> supplier) {
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        return () -> {
            Object value = supplier.get();
            Preconditions.checkNotNull(value, (Object)"value");
            return new SoftValue(value);
        };
    }

    private SoftValue(T value) {
        this.value = new SoftReference<T>(value);
    }

    @Override
    @Nullable
    public T getOrNull() {
        return this.value.get();
    }

    @Override
    public boolean shouldExpire() {
        return this.value.get() == null;
    }
}

