/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging.bungee;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.lucko.helper.Schedulers;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.plugin.HelperPlugin;
import me.lucko.helper.terminable.composite.CompositeTerminable;
import me.lucko.helper.utils.Players;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

@NonnullByDefault
public final class BungeeMessaging
implements PluginMessageListener {
    @Nullable
    private static BungeeMessaging instance = null;
    public static final String ALL_SERVERS = "ALL";
    public static final String ONLINE_SERVERS = "ONLINE";
    private static final String CHANNEL = "BungeeCord";
    private final HelperPlugin plugin;
    private final CompositeTerminable terminableRegistry = CompositeTerminable.create();
    private final List<MessageCallback> listeners = new LinkedList<MessageCallback>();
    private final Set<MessageAgent> queuedMessages = ConcurrentHashMap.newKeySet();
    private final ReentrantLock lock = new ReentrantLock();

    private static synchronized BungeeMessaging get() {
        if (instance == null) {
            instance = new BungeeMessaging();
        }
        return instance;
    }

    private static void register(MessageAgent agent) {
        BungeeMessaging.get().sendMessage(agent);
    }

    public static void connect(Player player, String serverName) {
        BungeeMessaging.register(new ConnectAgent(player, serverName));
    }

    public static void connectOther(String playerName, String serverName) {
        BungeeMessaging.register(new ConnectOtherAgent(playerName, serverName));
    }

    public static void ip(Player player, Consumer<Map.Entry<String, Integer>> callback) {
        BungeeMessaging.register(new IPAgent(player, callback));
    }

    public static void playerCount(String serverName, Consumer<Integer> callback) {
        BungeeMessaging.register(new PlayerCountAgent(serverName, callback));
    }

    public static void playerList(String serverName, Consumer<List<String>> callback) {
        BungeeMessaging.register(new PlayerListAgent(serverName, callback));
    }

    public static void getServers(Consumer<List<String>> callback) {
        BungeeMessaging.register(new GetServersAgent(callback));
    }

    public static void message(String playerName, String message) {
        BungeeMessaging.register(new PlayerMessageAgent(playerName, message));
    }

    public static void getServer(Consumer<String> callback) {
        BungeeMessaging.register(new GetServerAgent(callback));
    }

    public static void uuid(Player player, Consumer<UUID> callback) {
        BungeeMessaging.register(new UUIDAgent(player, callback));
    }

    public static void uuidOther(String playerName, Consumer<UUID> callback) {
        BungeeMessaging.register(new UUIDOtherAgent(playerName, callback));
    }

    public static void serverIp(String serverName, Consumer<Map.Entry<String, Integer>> callback) {
        BungeeMessaging.register(new ServerIPAgent(serverName, callback));
    }

    public static void kickPlayer(String playerName, String reason) {
        BungeeMessaging.register(new KickPlayerAgent(playerName, reason));
    }

    public static void forward(String serverName, String channelName, byte[] data) {
        BungeeMessaging.register(new ForwardAgent(serverName, channelName, data));
    }

    public static void forward(String serverName, String channelName, ByteArrayDataOutput data) {
        BungeeMessaging.register(new ForwardAgent(serverName, channelName, data));
    }

    public static void forwardToPlayer(String playerName, String channelName, byte[] data) {
        BungeeMessaging.register(new ForwardToPlayerAgent(playerName, channelName, data));
    }

    public static void forwardToPlayer(String playerName, String channelName, ByteArrayDataOutput data) {
        BungeeMessaging.register(new ForwardToPlayerAgent(playerName, channelName, data));
    }

    public static void registerForwardCallbackRaw(String channelName, Predicate<byte[]> callback) {
        ForwardCustomCallback customCallback = new ForwardCustomCallback(channelName, callback);
        BungeeMessaging.get().registerListener(customCallback);
    }

    public static void registerForwardCallback(String channelName, Predicate<ByteArrayDataInput> callback) {
        Predicate cb = (Predicate)Preconditions.checkNotNull(callback, (Object)"callback");
        ForwardCustomCallback customCallback = new ForwardCustomCallback(channelName, bytes -> cb.test(ByteStreams.newDataInput((byte[])bytes)));
        BungeeMessaging.get().registerListener(customCallback);
    }

    private BungeeMessaging() {
        this.plugin = LoaderUtils.getPlugin();
        this.plugin.bind(() -> {
            instance = null;
            this.terminableRegistry.closeAndReportException();
        });
        this.plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, CHANNEL);
        this.terminableRegistry.bind(() -> this.plugin.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, CHANNEL));
        this.plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, CHANNEL, (PluginMessageListener)this);
        this.terminableRegistry.bind(() -> this.plugin.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, CHANNEL, (PluginMessageListener)this));
        Schedulers.builder().sync().afterAndEvery(3L, TimeUnit.SECONDS).run(() -> {
            if (this.queuedMessages.isEmpty()) {
                return;
            }
            Player p = (Player)Iterables.getFirst(Players.all(), null);
            if (p != null) {
                this.queuedMessages.removeIf(ma -> {
                    this.sendToChannel((MessageAgent)ma, p);
                    return true;
                });
            }
        }).bindWith(this.terminableRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPluginMessageReceived(String channel, Player player, byte[] data) {
        if (!channel.equals(CHANNEL)) {
            return;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayDataInput in = ByteStreams.newDataInput((ByteArrayInputStream)inputStream);
        String subChannel = in.readUTF();
        inputStream.mark(0);
        this.lock.lock();
        try {
            Iterator<MessageCallback> it = this.listeners.iterator();
            while (it.hasNext()) {
                MessageCallback e = it.next();
                if (!e.getSubChannel().equals(subChannel)) continue;
                inputStream.reset();
                boolean accepted = e.test(player, in);
                if (!accepted) continue;
                inputStream.reset();
                boolean shouldRemove = e.accept(player, in);
                if (!shouldRemove) continue;
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void sendMessage(MessageAgent agent) {
        Player player = agent.getHandle();
        if (player != null) {
            if (!player.isOnline()) {
                throw new IllegalStateException("Player not online");
            }
            this.sendToChannel(agent, player);
            return;
        }
        player = (Player)Iterables.getFirst(Players.all(), null);
        if (player != null) {
            this.sendToChannel(agent, player);
        } else {
            this.queuedMessages.add(agent);
        }
    }

    private void sendToChannel(MessageAgent agent, Player player) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(agent.getSubChannel());
        agent.appendPayload(out);
        byte[] data = out.toByteArray();
        player.sendPluginMessage((Plugin)this.plugin, CHANNEL, data);
        if (agent instanceof MessageCallback) {
            MessageCallback callback = (MessageCallback)((Object)agent);
            this.registerListener(callback);
        }
    }

    private void registerListener(MessageCallback callback) {
        this.lock.lock();
        try {
            this.listeners.add(callback);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class ForwardCustomCallback
    implements MessageCallback {
        private final String subChannel;
        private final Predicate<byte[]> callback;

        private ForwardCustomCallback(String subChannel, Predicate<byte[]> callback) {
            this.subChannel = (String)Preconditions.checkNotNull((Object)subChannel, (Object)"subChannel");
            this.callback = (Predicate)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return this.subChannel;
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            short len = in.readShort();
            byte[] data = new byte[len];
            in.readFully(data);
            return this.callback.test(data);
        }
    }

    private static final class ForwardToPlayerAgent
    implements MessageAgent {
        private static final String CHANNEL = "ForwardToPlayer";
        private final String playerName;
        private final String channelName;
        private final byte[] data;

        private ForwardToPlayerAgent(String playerName, String channelName, byte[] data) {
            this.playerName = (String)Preconditions.checkNotNull((Object)playerName, (Object)"playerName");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (Object)"channelName");
            this.data = data;
        }

        private ForwardToPlayerAgent(String playerName, String channelName, ByteArrayDataOutput data) {
            this.playerName = (String)Preconditions.checkNotNull((Object)playerName, (Object)"playerName");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (Object)"channelName");
            this.data = ((ByteArrayDataOutput)Preconditions.checkNotNull((Object)data, (Object)"data")).toByteArray();
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
            out.writeUTF(this.channelName);
            out.writeShort(this.data.length);
            out.write(this.data);
        }
    }

    private static final class ForwardAgent
    implements MessageAgent {
        private static final String CHANNEL = "Forward";
        private final String serverName;
        private final String channelName;
        private final byte[] data;

        private ForwardAgent(String serverName, String channelName, byte[] data) {
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"serverName");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (Object)"channelName");
            this.data = data;
        }

        private ForwardAgent(String serverName, String channelName, ByteArrayDataOutput data) {
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"serverName");
            this.channelName = (String)Preconditions.checkNotNull((Object)channelName, (Object)"channelName");
            this.data = ((ByteArrayDataOutput)Preconditions.checkNotNull((Object)data, (Object)"data")).toByteArray();
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
            out.writeUTF(this.channelName);
            out.writeShort(this.data.length);
            out.write(this.data);
        }
    }

    private static final class KickPlayerAgent
    implements MessageAgent {
        private static final String CHANNEL = "KickPlayer";
        private final String playerName;
        private final String reason;

        private KickPlayerAgent(String playerName, String reason) {
            this.playerName = (String)Preconditions.checkNotNull((Object)playerName, (Object)"playerName");
            this.reason = (String)Preconditions.checkNotNull((Object)reason, (Object)"reason");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
            out.writeUTF(this.reason);
        }
    }

    private static final class ServerIPAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "ServerIP";
        private final String serverName;
        private final Consumer<Map.Entry<String, Integer>> callback;

        private ServerIPAgent(String serverName, Consumer<Map.Entry<String, Integer>> callback) {
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"serverName");
            this.callback = (Consumer)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
        }

        @Override
        public boolean test(Player receiver, ByteArrayDataInput in) {
            return in.readUTF().equalsIgnoreCase(this.serverName);
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            in.readUTF();
            String ip = in.readUTF();
            int port = in.readInt();
            this.callback.accept(Maps.immutableEntry((Object)ip, (Object)port));
            return true;
        }
    }

    private static final class UUIDOtherAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "UUIDOther";
        private final String playerName;
        private final Consumer<UUID> callback;

        private UUIDOtherAgent(String playerName, Consumer<UUID> callback) {
            this.playerName = (String)Preconditions.checkNotNull((Object)playerName, (Object)"playerName");
            this.callback = (Consumer)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
        }

        @Override
        public boolean test(Player receiver, ByteArrayDataInput in) {
            return in.readUTF().equalsIgnoreCase(this.playerName);
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            in.readUTF();
            String uuid = in.readUTF();
            this.callback.accept(UUID.fromString(uuid));
            return true;
        }
    }

    private static final class UUIDAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "UUID";
        private final Player player;
        private final Consumer<UUID> callback;

        private UUIDAgent(Player player, Consumer<UUID> callback) {
            this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
            this.callback = (Consumer)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public Player getHandle() {
            return this.player;
        }

        @Override
        public boolean test(Player receiver, ByteArrayDataInput in) {
            return receiver.getUniqueId().equals(this.player.getUniqueId());
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            String uuid = in.readUTF();
            this.callback.accept(UUID.fromString(uuid));
            return true;
        }
    }

    private static final class GetServerAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "GetServer";
        private final Consumer<String> callback;

        private GetServerAgent(Consumer<String> callback) {
            this.callback = (Consumer)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            this.callback.accept(in.readUTF());
            return true;
        }
    }

    private static final class PlayerMessageAgent
    implements MessageAgent {
        private static final String CHANNEL = "Message";
        private final String playerName;
        private final String message;

        private PlayerMessageAgent(String playerName, String message) {
            this.playerName = (String)Preconditions.checkNotNull((Object)playerName, (Object)"playerName");
            this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
            out.writeUTF(this.message);
        }
    }

    private static final class GetServersAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "GetServers";
        private final Consumer<List<String>> callback;

        private GetServersAgent(Consumer<List<String>> callback) {
            this.callback = (Consumer)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            String csv = in.readUTF();
            if (csv.isEmpty()) {
                this.callback.accept((List<String>)ImmutableList.of());
                return true;
            }
            this.callback.accept((List<String>)ImmutableList.copyOf((Collection)Splitter.on((String)", ").splitToList((CharSequence)csv)));
            return true;
        }
    }

    private static final class PlayerListAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "PlayerList";
        private final String serverName;
        private final Consumer<List<String>> callback;

        private PlayerListAgent(String serverName, Consumer<List<String>> callback) {
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"serverName");
            this.callback = (Consumer)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
        }

        @Override
        public boolean test(Player receiver, ByteArrayDataInput in) {
            return in.readUTF().equalsIgnoreCase(this.serverName);
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            in.readUTF();
            String csv = in.readUTF();
            if (csv.isEmpty()) {
                this.callback.accept((List<String>)ImmutableList.of());
                return true;
            }
            this.callback.accept((List<String>)ImmutableList.copyOf((Collection)Splitter.on((String)", ").splitToList((CharSequence)csv)));
            return true;
        }
    }

    private static final class PlayerCountAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "PlayerCount";
        private final String serverName;
        private final Consumer<Integer> callback;

        private PlayerCountAgent(String serverName, Consumer<Integer> callback) {
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"serverName");
            this.callback = (Consumer)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
        }

        @Override
        public boolean test(Player receiver, ByteArrayDataInput in) {
            return in.readUTF().equalsIgnoreCase(this.serverName);
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            in.readUTF();
            int count = in.readInt();
            this.callback.accept(count);
            return true;
        }
    }

    private static final class IPAgent
    implements MessageAgent,
    MessageCallback {
        private static final String CHANNEL = "IP";
        private final Player player;
        private final Consumer<Map.Entry<String, Integer>> callback;

        private IPAgent(Player player, Consumer<Map.Entry<String, Integer>> callback) {
            this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
            this.callback = (Consumer)Preconditions.checkNotNull(callback, (Object)"callback");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public Player getHandle() {
            return this.player;
        }

        @Override
        public boolean test(Player receiver, ByteArrayDataInput in) {
            return receiver.getUniqueId().equals(this.player.getUniqueId());
        }

        @Override
        public boolean accept(Player receiver, ByteArrayDataInput in) {
            String ip = in.readUTF();
            int port = in.readInt();
            this.callback.accept(Maps.immutableEntry((Object)ip, (Object)port));
            return true;
        }
    }

    private static final class ConnectOtherAgent
    implements MessageAgent {
        private static final String CHANNEL = "ConnectOther";
        private final String playerName;
        private final String serverName;

        private ConnectOtherAgent(String playerName, String serverName) {
            this.playerName = (String)Preconditions.checkNotNull((Object)playerName, (Object)"playerName");
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"serverName");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.playerName);
            out.writeUTF(this.serverName);
        }
    }

    private static final class ConnectAgent
    implements MessageAgent {
        private static final String CHANNEL = "Connect";
        private final Player player;
        private final String serverName;

        private ConnectAgent(Player player, String serverName) {
            this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"serverName");
        }

        @Override
        public String getSubChannel() {
            return CHANNEL;
        }

        @Override
        public Player getHandle() {
            return this.player;
        }

        @Override
        public void appendPayload(ByteArrayDataOutput out) {
            out.writeUTF(this.serverName);
        }
    }

    private static interface MessageCallback {
        public String getSubChannel();

        default public boolean test(Player receiver, ByteArrayDataInput in) {
            return true;
        }

        public boolean accept(Player var1, ByteArrayDataInput var2);
    }

    private static interface MessageAgent {
        public String getSubChannel();

        @Nullable
        default public Player getHandle() {
            return null;
        }

        default public void appendPayload(ByteArrayDataOutput out) {
        }
    }
}

