/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.Schedulers;
import me.lucko.helper.gson.GsonProvider;
import me.lucko.helper.messaging.Channel;
import me.lucko.helper.messaging.ChannelAgent;
import me.lucko.helper.messaging.ChannelListener;
import me.lucko.helper.messaging.Messenger;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public class AbstractMessenger
implements Messenger {
    private final LoadingCache<Map.Entry<String, TypeToken<?>>, AbstractChannel<?>> channels = CacheBuilder.newBuilder().build(new ChannelLoader());
    private final BiConsumer<String, String> outgoingMessages;
    private final Consumer<String> notifySub;
    private final Consumer<String> notifyUnsub;

    public AbstractMessenger(BiConsumer<String, String> outgoingMessages, Consumer<String> notifySub, Consumer<String> notifyUnsub) {
        this.outgoingMessages = (BiConsumer)Preconditions.checkNotNull(outgoingMessages, (Object)"outgoingMessages");
        this.notifySub = (Consumer)Preconditions.checkNotNull(notifySub, (Object)"notifySub");
        this.notifyUnsub = (Consumer)Preconditions.checkNotNull(notifyUnsub, (Object)"notifyUnsub");
    }

    public void registerIncomingMessage(String channel, String message) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel");
        Preconditions.checkNotNull((Object)message, (Object)"message");
        for (Map.Entry c : this.channels.asMap().entrySet()) {
            if (!((String)((Map.Entry)c.getKey()).getKey()).equals(channel)) continue;
            ((AbstractChannel)c.getValue()).onIncomingMessage(message);
        }
    }

    @Override
    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull TypeToken<T> type) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkArgument((!name.trim().isEmpty() ? 1 : 0) != 0, (Object)"name cannot be empty");
        Preconditions.checkNotNull(type, (Object)"type");
        return (Channel)this.channels.getUnchecked((Object)Maps.immutableEntry((Object)name, type));
    }

    private class ChannelLoader<T>
    extends CacheLoader<Map.Entry<String, TypeToken<T>>, Channel<T>> {
        private ChannelLoader() {
        }

        public Channel<T> load(Map.Entry<String, TypeToken<T>> spec) throws Exception {
            return new AbstractChannel(AbstractMessenger.this, spec.getKey(), spec.getValue());
        }
    }

    private static class AbstractChannelAgent<T>
    implements ChannelAgent<T> {
        @Nullable
        private AbstractChannel<T> channel;
        private final Set<ChannelListener<T>> listeners = ConcurrentHashMap.newKeySet();

        AbstractChannelAgent(AbstractChannel<T> channel) {
            this.channel = channel;
        }

        private void onIncomingMessage(T message) {
            for (ChannelListener<T> listener : this.listeners) {
                Schedulers.async().run(() -> {
                    try {
                        listener.onMessage(this, message);
                    }
                    catch (Exception e) {
                        new RuntimeException("Unable to pass decoded message to listener: " + listener, e).printStackTrace();
                    }
                });
            }
        }

        @Override
        public Channel<T> getChannel() {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            return this.channel;
        }

        @Override
        public Set<ChannelListener<T>> getListeners() {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            return ImmutableSet.copyOf(this.listeners);
        }

        @Override
        public boolean hasListeners() {
            return !this.listeners.isEmpty();
        }

        @Override
        public boolean addListener(ChannelListener<T> listener) {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            try {
                boolean bl = this.listeners.add(listener);
                return bl;
            }
            finally {
                ((AbstractChannel)this.channel).checkSubscription();
            }
        }

        @Override
        public boolean removeListener(ChannelListener<T> listener) {
            Preconditions.checkState((this.channel != null ? 1 : 0) != 0, (Object)"agent not active");
            try {
                boolean bl = this.listeners.remove(listener);
                return bl;
            }
            finally {
                ((AbstractChannel)this.channel).checkSubscription();
            }
        }

        @Override
        public void close() {
            if (this.channel == null) {
                return;
            }
            this.listeners.clear();
            ((AbstractChannel)this.channel).agents.remove(this);
            ((AbstractChannel)this.channel).checkSubscription();
            this.channel = null;
        }
    }

    private static class AbstractChannel<T>
    implements Channel<T> {
        private final AbstractMessenger messenger;
        private final String name;
        private final TypeToken<T> type;
        private final Set<AbstractChannelAgent<T>> agents = ConcurrentHashMap.newKeySet();
        private boolean subscribed = false;

        private AbstractChannel(AbstractMessenger messenger, String name, TypeToken<T> type) {
            this.messenger = messenger;
            this.name = name;
            this.type = type;
        }

        private void onIncomingMessage(String message) {
            try {
                Object decoded = GsonProvider.standard().fromJson(message, this.type.getType());
                Preconditions.checkNotNull((Object)decoded, (Object)"decoded");
                for (AbstractChannelAgent<T> agent : this.agents) {
                    try {
                        ((AbstractChannelAgent)agent).onIncomingMessage(decoded);
                    }
                    catch (Exception e) {
                        new RuntimeException("Unable to pass decoded message to agent: " + message, e).printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                new RuntimeException("Unable to decode message: " + message, e).printStackTrace();
            }
        }

        private void checkSubscription() {
            boolean shouldSubscribe = this.agents.stream().anyMatch(AbstractChannelAgent::hasListeners);
            if (shouldSubscribe == this.subscribed) {
                return;
            }
            this.subscribed = shouldSubscribe;
            Schedulers.async().run(() -> {
                try {
                    if (shouldSubscribe) {
                        this.messenger.notifySub.accept(this.name);
                    } else {
                        this.messenger.notifyUnsub.accept(this.name);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeToken<T> getType() {
            return this.type;
        }

        @Override
        public ChannelAgent<T> newAgent() {
            AbstractChannelAgent agent = new AbstractChannelAgent(this);
            this.agents.add(agent);
            return agent;
        }

        @Override
        public CompletableFuture<Boolean> sendMessage(T message) {
            return CompletableFuture.supplyAsync(() -> GsonProvider.standard().toJson(message, this.type.getType())).thenApply(m -> {
                try {
                    this.messenger.outgoingMessages.accept(this.name, m);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            });
        }
    }
}

