/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.scheme;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.IntFunction;
import me.lucko.helper.item.ItemStackBuilder;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.scheme.AbstractSchemeMapping;
import me.lucko.helper.menu.scheme.EmptySchemeMapping;
import me.lucko.helper.menu.scheme.SchemeMapping;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.Material;

@NonnullByDefault
public final class StandardSchemeMappings {
    public static final SchemeMapping STAINED_GLASS = StandardSchemeMappings.forColoredMaterial(Material.STAINED_GLASS_PANE);
    public static final SchemeMapping STAINED_GLASS_BLOCK = StandardSchemeMappings.forColoredMaterial(Material.STAINED_GLASS);
    public static final SchemeMapping HARDENED_CLAY = StandardSchemeMappings.forColoredMaterial(Material.STAINED_CLAY);
    public static final SchemeMapping WOOL = StandardSchemeMappings.forColoredMaterial(Material.WOOL);
    public static final SchemeMapping EMPTY = new EmptySchemeMapping();

    private static SchemeMapping forColoredMaterial(Material material) {
        IntFunction<Item> func = value -> ItemStackBuilder.of(material).name("&f").data(value).build(null);
        ImmutableMap map = ImmutableMap.builder().put((Object)0, (Object)func.apply(0)).put((Object)1, (Object)func.apply(1)).put((Object)2, (Object)func.apply(2)).put((Object)3, (Object)func.apply(3)).put((Object)4, (Object)func.apply(4)).put((Object)5, (Object)func.apply(5)).put((Object)6, (Object)func.apply(6)).put((Object)7, (Object)func.apply(7)).put((Object)8, (Object)func.apply(8)).put((Object)9, (Object)func.apply(9)).put((Object)10, (Object)func.apply(10)).put((Object)11, (Object)func.apply(11)).put((Object)12, (Object)func.apply(12)).put((Object)13, (Object)func.apply(13)).put((Object)14, (Object)func.apply(14)).put((Object)15, (Object)func.apply(15)).build();
        return AbstractSchemeMapping.of((Map<Integer, Item>)map);
    }

    private StandardSchemeMappings() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

