/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.hologram;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.gson.GsonSerializable;
import me.lucko.helper.hologram.SimpleHologram;
import me.lucko.helper.serialize.Position;
import me.lucko.helper.terminable.Terminable;
import org.bukkit.entity.Player;

public interface Hologram
extends Terminable,
GsonSerializable {
    @Nonnull
    public static Hologram create(@Nonnull Position position, @Nonnull List<String> lines) {
        return new SimpleHologram(position, lines);
    }

    public static Hologram deserialize(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument((boolean)object.has("position"));
        Preconditions.checkArgument((boolean)object.has("lines"));
        Position position = Position.deserialize(object.get("position"));
        JsonArray lineArray = object.get("lines").getAsJsonArray();
        ArrayList<String> lines = new ArrayList<String>();
        for (JsonElement e : lineArray) {
            lines.add(e.getAsString());
        }
        return Hologram.create(position, lines);
    }

    public void spawn();

    public void despawn();

    public boolean isSpawned();

    public void updatePosition(@Nonnull Position var1);

    public void updateLines(@Nonnull List<String> var1);

    public void setClickCallback(@Nullable Consumer<Player> var1);
}

