/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson.converter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import me.lucko.helper.gson.converter.AbstractGsonConverter;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
class ImmutableGsonConverter
extends AbstractGsonConverter<ImmutableMap<String, Object>, ImmutableList<Object>, ImmutableSet<Object>> {
    public static final ImmutableGsonConverter INSTANCE = new ImmutableGsonConverter();

    private ImmutableGsonConverter() {
    }

    @Override
    protected AbstractGsonConverter.MapBuilder<ImmutableMap<String, Object>, String, Object> newMapBuilder() {
        return new ImmutableMapBuilder<String, Object>();
    }

    @Override
    protected AbstractGsonConverter.ListBuilder<ImmutableList<Object>, Object> newListBuilder() {
        return new ImmutableListBuilder<Object>();
    }

    @Override
    protected AbstractGsonConverter.SetBuilder<ImmutableSet<Object>, Object> newSetBuilder() {
        return new ImmutableSetBuilder<Object>();
    }

    private static final class ImmutableSetBuilder<E>
    implements AbstractGsonConverter.SetBuilder<ImmutableSet<E>, E> {
        private final ImmutableSet.Builder<E> builder = ImmutableSet.builder();

        private ImmutableSetBuilder() {
        }

        @Override
        public void add(@Nullable E element) {
            if (element == null) {
                return;
            }
            this.builder.add(element);
        }

        @Override
        public ImmutableSet<E> build() {
            return this.builder.build();
        }
    }

    private static final class ImmutableListBuilder<E>
    implements AbstractGsonConverter.ListBuilder<ImmutableList<E>, E> {
        private final ImmutableList.Builder<E> builder = ImmutableList.builder();

        private ImmutableListBuilder() {
        }

        @Override
        public void add(@Nullable E element) {
            if (element == null) {
                return;
            }
            this.builder.add(element);
        }

        @Override
        public ImmutableList<E> build() {
            return this.builder.build();
        }
    }

    private static final class ImmutableMapBuilder<K, V>
    implements AbstractGsonConverter.MapBuilder<ImmutableMap<K, V>, K, V> {
        private final ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();

        private ImmutableMapBuilder() {
        }

        @Override
        public void put(@Nullable K key, @Nullable V value) {
            if (key == null || value == null) {
                return;
            }
            this.builder.put(key, value);
        }

        @Override
        public ImmutableMap<K, V> build() {
            return this.builder.build();
        }
    }
}

