/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson.configurate;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import me.lucko.helper.gson.converter.GsonConverters;

public class JsonPrimitiveSerializer
implements TypeSerializer<JsonPrimitive> {
    public static final JsonPrimitiveSerializer INSTANCE = new JsonPrimitiveSerializer();

    private JsonPrimitiveSerializer() {
    }

    @Override
    public JsonPrimitive deserialize(TypeToken<?> type, ConfigurationNode node) throws ObjectMappingException {
        Object value = node.getValue(JsonNull.INSTANCE);
        if (value instanceof String) {
            return new JsonPrimitive((String)value);
        }
        if (value instanceof Character) {
            return new JsonPrimitive((Character)value);
        }
        if (value instanceof Boolean) {
            return new JsonPrimitive((Boolean)value);
        }
        if (value instanceof Number) {
            return new JsonPrimitive((Number)value);
        }
        throw new ObjectMappingException("Unable to wrap object: " + value.getClass());
    }

    @Override
    public void serialize(TypeToken<?> type, JsonPrimitive primitive, ConfigurationNode node) throws ObjectMappingException {
        node.setValue(GsonConverters.IMMUTABLE.unwarpPrimitive(primitive));
    }
}

