/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson.configurate;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;

public class JsonObjectSerializer
implements TypeSerializer<JsonObject> {
    private static final TypeToken<JsonElement> JSON_ELEMENT_TYPE = TypeToken.of(JsonElement.class);
    public static final JsonObjectSerializer INSTANCE = new JsonObjectSerializer();

    private JsonObjectSerializer() {
    }

    @Override
    public JsonObject deserialize(TypeToken<?> type, ConfigurationNode node) throws ObjectMappingException {
        JsonObject object = new JsonObject();
        for (Map.Entry<Object, ? extends ConfigurationNode> child : node.getChildrenMap().entrySet()) {
            object.add(child.getKey().toString(), child.getValue().getValue(JSON_ELEMENT_TYPE));
        }
        return object;
    }

    @Override
    public void serialize(TypeToken<?> type, JsonObject object, ConfigurationNode node) throws ObjectMappingException {
        for (Map.Entry e : object.entrySet()) {
            node.getNode(e.getKey()).setValue(JSON_ELEMENT_TYPE, e.getValue());
        }
    }
}

