/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson.configurate;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonNull;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;

public class JsonNullSerializer
implements TypeSerializer<JsonNull> {
    private static final TypeToken<JsonNull> JSON_NULL_TYPE = TypeToken.of(JsonNull.class);
    public static final JsonNullSerializer INSTANCE = new JsonNullSerializer();

    private JsonNullSerializer() {
    }

    @Override
    public JsonNull deserialize(TypeToken<?> type, ConfigurationNode node) throws ObjectMappingException {
        if (!type.equals(JSON_NULL_TYPE)) {
            throw new ObjectMappingException("Unable to map type: " + type.toString());
        }
        return JsonNull.INSTANCE;
    }

    @Override
    public void serialize(TypeToken<?> type, JsonNull jsonNull, ConfigurationNode node) throws ObjectMappingException {
        if (!type.equals(JSON_NULL_TYPE)) {
            throw new ObjectMappingException("Unable to map type: " + type.toString());
        }
        node.setValue(null);
    }
}

