/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson.configurate;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.ArrayList;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;

public class JsonArraySerializer
implements TypeSerializer<JsonArray> {
    private static final TypeToken<JsonElement> JSON_ELEMENT_TYPE = TypeToken.of(JsonElement.class);
    public static final JsonArraySerializer INSTANCE = new JsonArraySerializer();

    private JsonArraySerializer() {
    }

    @Override
    public JsonArray deserialize(TypeToken<?> type, ConfigurationNode node) throws ObjectMappingException {
        JsonArray array = new JsonArray();
        for (ConfigurationNode configurationNode : node.getChildrenList()) {
            array.add((JsonElement)configurationNode.getValue(JSON_ELEMENT_TYPE, JsonNull.INSTANCE));
        }
        return array;
    }

    @Override
    public void serialize(TypeToken<?> type, JsonArray array, ConfigurationNode node) throws ObjectMappingException {
        ArrayList<JsonElement> objects = new ArrayList<JsonElement>();
        for (JsonElement e : array) {
            objects.add(e);
        }
        node.setValue(objects);
    }
}

