/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson;

import com.google.common.math.DoubleMath;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public final class BukkitSerializableAdapterFactory
implements TypeAdapterFactory {
    @Nonnull
    public static final BukkitSerializableAdapterFactory INSTANCE = new BukkitSerializableAdapterFactory();

    private BukkitSerializableAdapterFactory() {
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class clazz = type.getRawType();
        if (!ConfigurationSerializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        return new Adapter(gson);
    }

    private static final class Adapter
    extends TypeAdapter<ConfigurationSerializable> {
        private static final Type RAW_OUTPUT_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
        private final Gson gson;

        private Adapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, ConfigurationSerializable value) {
            Map serialized = value.serialize();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(serialized.size() + 1);
            map.put("==", ConfigurationSerialization.getAlias(value.getClass()));
            map.putAll(serialized);
            this.gson.toJson(map, RAW_OUTPUT_TYPE, out);
        }

        public ConfigurationSerializable read(JsonReader in) {
            Map map = (Map)this.gson.fromJson(in, RAW_OUTPUT_TYPE);
            this.deserializeChildren(map);
            return ConfigurationSerialization.deserializeObject((Map)map);
        }

        private void deserializeChildren(Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                long l;
                Object value2;
                if (entry.getValue() instanceof Map) {
                    try {
                        value2 = (Map)entry.getValue();
                        this.deserializeChildren((Map<String, Object>)value2);
                        if (value2.containsKey("==")) {
                            entry.setValue(ConfigurationSerialization.deserializeObject((Map)value2));
                        }
                    }
                    catch (Exception value2) {
                        // empty catch block
                    }
                }
                if (!(entry.getValue() instanceof Number)) continue;
                value2 = (Number)entry.getValue();
                if (value2 instanceof Double && DoubleMath.isMathematicalInteger((double)((Number)value2).doubleValue())) {
                    value2 = ((Number)value2).intValue();
                }
                if (value2 instanceof Long && (l = ((Number)value2).longValue()) <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    value2 = ((Number)value2).intValue();
                }
                entry.setValue(value2);
            }
        }
    }
}

