/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.function.chain;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.lucko.helper.function.chain.Chain;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
class SimpleChain<T>
implements Chain<T> {
    @Nullable
    private T object;

    SimpleChain(@Nullable T object) {
        this.object = object;
    }

    @Override
    public Chain<T> apply(Consumer<? super T> action) {
        Preconditions.checkNotNull(action, (Object)"action");
        action.accept(this.object);
        return this;
    }

    @Override
    public Chain<T> applyIf(Predicate<? super T> test, Consumer<? super T> action) {
        Preconditions.checkNotNull(test, (Object)"test");
        Preconditions.checkNotNull(action, (Object)"action");
        if (test.test(this.object)) {
            action.accept(this.object);
        }
        return this;
    }

    @Override
    public Chain<T> applyIfNonNull(Consumer<? super T> action) {
        Preconditions.checkNotNull(action, (Object)"action");
        if (this.object != null) {
            action.accept(this.object);
        }
        return this;
    }

    @Override
    public Chain<T> orElse(Predicate<? super T> test, T failValue) {
        Preconditions.checkNotNull(test, (Object)"test");
        if (!test.test(this.object)) {
            this.object = failValue;
        }
        return this;
    }

    @Override
    public Chain<T> orElseIfNull(T otherValue) {
        if (this.object == null) {
            this.object = otherValue;
        }
        return this;
    }

    @Override
    public Chain<T> orElseGet(Predicate<? super T> test, Supplier<? extends T> failSupplier) {
        Preconditions.checkNotNull(test, (Object)"test");
        Preconditions.checkNotNull(failSupplier, (Object)"failSupplier");
        if (!test.test(this.object)) {
            this.object = failSupplier.get();
        }
        return this;
    }

    @Override
    public Chain<T> orElseGetIfNull(Supplier<? extends T> supplier) {
        Preconditions.checkNotNull(supplier, (Object)"supplier");
        if (this.object == null) {
            this.object = supplier.get();
        }
        return this;
    }

    @Override
    public <R> Chain<R> ifElse(Predicate<? super T> test, R passValue, R failValue) {
        Preconditions.checkNotNull(test, (Object)"test");
        return test.test(this.object) ? this.map(s -> passValue) : this.map(s -> failValue);
    }

    @Override
    public <R> Chain<R> map(Function<? super T, ? extends R> mapper) {
        Preconditions.checkNotNull(mapper, (Object)"mapper");
        R result = mapper.apply(this.object);
        if (result == this.object) {
            return this;
        }
        return new SimpleChain<R>(result);
    }

    @Override
    public <R> Chain<R> mapOrElse(Predicate<? super T> test, Function<? super T, ? extends R> passedMapper, R otherValue) {
        Preconditions.checkNotNull(test, (Object)"test");
        Preconditions.checkNotNull(passedMapper, (Object)"passedMapper");
        return this.mapOrElse(test, passedMapper, s -> otherValue);
    }

    @Override
    public <R> Chain<R> mapOrElse(Predicate<? super T> test, Function<? super T, ? extends R> passedMapper, Function<? super T, ? extends R> failedMapper) {
        Preconditions.checkNotNull(test, (Object)"test");
        Preconditions.checkNotNull(passedMapper, (Object)"passedMapper");
        Preconditions.checkNotNull(failedMapper, (Object)"failedMapper");
        return test.test(this.object) ? this.map(passedMapper) : this.map(failedMapper);
    }

    @Override
    public <R> Chain<R> mapNullSafe(Function<? super T, ? extends R> nonNullMapper, R otherValue) {
        Preconditions.checkNotNull(nonNullMapper, (Object)"nonNullMapper");
        return this.mapNullSafeGet(nonNullMapper, () -> otherValue);
    }

    @Override
    public <R> Chain<R> mapNullSafeGet(Function<? super T, ? extends R> nonNullMapper, Supplier<? extends R> nullSupplier) {
        R result;
        Preconditions.checkNotNull(nonNullMapper, (Object)"nonNullMapper");
        Preconditions.checkNotNull(nullSupplier, (Object)"nullSupplier");
        R r = result = this.object != null ? nonNullMapper.apply(this.object) : nullSupplier.get();
        if (result == this.object) {
            return this;
        }
        return new SimpleChain<R>(result);
    }

    @Override
    public <R> Chain<R> flatMap(Function<? super T, ? extends Chain<? extends R>> mapper) {
        Preconditions.checkNotNull(mapper, (Object)"mapper");
        return mapper.apply(this.object);
    }

    @Override
    public Optional<T> end() {
        return Optional.ofNullable(this.object);
    }

    @Override
    @Nullable
    public T endOrNull() {
        return this.object;
    }
}

