/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.event.functional.single;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import me.lucko.helper.event.SingleSubscription;
import me.lucko.helper.event.functional.single.HelperEventListener;
import me.lucko.helper.event.functional.single.SingleBuilder;
import me.lucko.helper.event.functional.single.SingleHandlerList;
import me.lucko.helper.internal.LoaderUtils;
import org.bukkit.event.Event;

class SingleHandlerListImpl<T extends Event>
implements SingleHandlerList<T> {
    private final SingleBuilder<T> builder;
    private final List<BiConsumer<SingleSubscription<T>, ? super T>> handlers = new ArrayList<BiConsumer<SingleSubscription<T>, ? super T>>(1);

    SingleHandlerListImpl(@Nonnull SingleBuilder<T> builder) {
        this.builder = builder;
    }

    @Override
    @Nonnull
    public SingleHandlerList<T> biConsumer(@Nonnull BiConsumer<SingleSubscription<T>, ? super T> handler) {
        Preconditions.checkNotNull(handler, (Object)"handler");
        this.handlers.add(handler);
        return this;
    }

    @Override
    @Nonnull
    public SingleSubscription<T> register() {
        if (this.handlers.isEmpty()) {
            throw new IllegalStateException("No handlers have been registered");
        }
        HelperEventListener<T> listener = new HelperEventListener<T>(this.builder, this.handlers);
        listener.register(LoaderUtils.getPlugin());
        return listener;
    }
}

