/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.event.functional.merged;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.lucko.helper.event.MergedSubscription;
import me.lucko.helper.event.functional.ExpiryTestStage;
import me.lucko.helper.event.functional.merged.MergedHandlerList;
import me.lucko.helper.event.functional.merged.MergedHandlerListImpl;
import me.lucko.helper.event.functional.merged.MergedHandlerMapping;
import me.lucko.helper.event.functional.merged.MergedSubscriptionBuilder;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

class MergedBuilder<T>
implements MergedSubscriptionBuilder<T> {
    final TypeToken<T> handledClass;
    final Map<Class<? extends Event>, MergedHandlerMapping<T, ? extends Event>> mappings = new HashMap<Class<? extends Event>, MergedHandlerMapping<T, ? extends Event>>();
    BiConsumer<Event, Throwable> exceptionConsumer = DEFAULT_EXCEPTION_CONSUMER;
    final List<Predicate<T>> filters = new ArrayList<Predicate<T>>();
    final List<BiPredicate<MergedSubscription<T>, T>> preExpiryTests = new ArrayList<BiPredicate<MergedSubscription<T>, T>>(0);
    final List<BiPredicate<MergedSubscription<T>, T>> midExpiryTests = new ArrayList<BiPredicate<MergedSubscription<T>, T>>(0);
    final List<BiPredicate<MergedSubscription<T>, T>> postExpiryTests = new ArrayList<BiPredicate<MergedSubscription<T>, T>>(0);

    MergedBuilder(TypeToken<T> handledClass) {
        this.handledClass = handledClass;
    }

    @Override
    @Nonnull
    public <E extends Event> MergedSubscriptionBuilder<T> bindEvent(@Nonnull Class<E> eventClass, @Nonnull Function<E, T> function) {
        return this.bindEvent(eventClass, EventPriority.NORMAL, function);
    }

    @Override
    @Nonnull
    public <E extends Event> MergedSubscriptionBuilder<T> bindEvent(@Nonnull Class<E> eventClass, @Nonnull EventPriority priority, @Nonnull Function<E, T> function) {
        Preconditions.checkNotNull(eventClass, (Object)"eventClass");
        Preconditions.checkNotNull((Object)priority, (Object)"priority");
        Preconditions.checkNotNull(function, (Object)"function");
        this.mappings.put(eventClass, new MergedHandlerMapping<T, E>(priority, function));
        return this;
    }

    @Override
    @Nonnull
    public MergedSubscriptionBuilder<T> expireIf(@Nonnull BiPredicate<MergedSubscription<T>, T> predicate, ExpiryTestStage ... testPoints) {
        Preconditions.checkNotNull((Object)testPoints, (Object)"testPoints");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        block5: for (ExpiryTestStage testPoint : testPoints) {
            switch (testPoint) {
                case PRE: {
                    this.preExpiryTests.add(predicate);
                    continue block5;
                }
                case POST_FILTER: {
                    this.midExpiryTests.add(predicate);
                    continue block5;
                }
                case POST_HANDLE: {
                    this.postExpiryTests.add(predicate);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ExpiryTestPoint: " + (Object)((Object)testPoint));
                }
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public MergedSubscriptionBuilder<T> filter(@Nonnull Predicate<T> predicate) {
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        this.filters.add(predicate);
        return this;
    }

    @Override
    @Nonnull
    public MergedSubscriptionBuilder<T> exceptionConsumer(@Nonnull BiConsumer<Event, Throwable> exceptionConsumer) {
        Preconditions.checkNotNull(exceptionConsumer, (Object)"exceptionConsumer");
        this.exceptionConsumer = exceptionConsumer;
        return this;
    }

    @Override
    @Nonnull
    public MergedHandlerList<T> handlers() {
        if (this.mappings.isEmpty()) {
            throw new IllegalStateException("No mappings were created");
        }
        return new MergedHandlerListImpl(this);
    }
}

