/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.event.functional.merged;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.lucko.helper.Helper;
import me.lucko.helper.event.MergedSubscription;
import me.lucko.helper.event.functional.merged.MergedBuilder;
import me.lucko.helper.event.functional.merged.MergedHandlerMapping;
import me.lucko.helper.interfaces.Delegate;
import me.lucko.helper.timings.MCTiming;
import me.lucko.helper.timings.Timings;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

class HelperMergedEventListener<T>
implements MergedSubscription<T>,
EventExecutor,
Listener {
    private final TypeToken<T> handledClass;
    private final Map<Class<? extends Event>, MergedHandlerMapping<T, ? extends Event>> mappings;
    private final BiConsumer<Event, Throwable> exceptionConsumer;
    private final Predicate<T>[] filters;
    private final BiPredicate<MergedSubscription<T>, T>[] preExpiryTests;
    private final BiPredicate<MergedSubscription<T>, T>[] midExpiryTests;
    private final BiPredicate<MergedSubscription<T>, T>[] postExpiryTests;
    private final BiConsumer<MergedSubscription<T>, ? super T>[] handlers;
    private final MCTiming timing;
    private final AtomicLong callCount = new AtomicLong(0L);
    private final AtomicBoolean active = new AtomicBoolean(true);

    HelperMergedEventListener(MergedBuilder<T> builder, List<BiConsumer<MergedSubscription<T>, ? super T>> handlers) {
        this.handledClass = builder.handledClass;
        this.mappings = ImmutableMap.copyOf(builder.mappings);
        this.exceptionConsumer = builder.exceptionConsumer;
        this.filters = builder.filters.toArray(new Predicate[builder.filters.size()]);
        this.preExpiryTests = builder.preExpiryTests.toArray(new BiPredicate[builder.preExpiryTests.size()]);
        this.midExpiryTests = builder.midExpiryTests.toArray(new BiPredicate[builder.midExpiryTests.size()]);
        this.postExpiryTests = builder.postExpiryTests.toArray(new BiPredicate[builder.postExpiryTests.size()]);
        this.handlers = handlers.toArray(new BiConsumer[handlers.size()]);
        this.timing = Timings.of("helper-events: " + handlers.stream().map(handler -> Delegate.resolve(handler).getClass().getName()).collect(Collectors.joining(" | ")));
    }

    void register(Plugin plugin) {
        for (Map.Entry<Class<Event>, MergedHandlerMapping<T, Event>> ent : this.mappings.entrySet()) {
            Helper.plugins().registerEvent(ent.getKey(), (Listener)this, ent.getValue().getPriority(), (EventExecutor)this, plugin, false);
        }
    }

    public void execute(Listener listener, Event event) {
        Function<Object, Event> function = null;
        for (Map.Entry<Class<Event>, MergedHandlerMapping<T, Event>> entry : this.mappings.entrySet()) {
            if (event.getClass() != entry.getKey()) continue;
            function = entry.getValue().getFunction();
            break;
        }
        if (function == null) {
            return;
        }
        if (!this.active.get()) {
            event.getHandlers().unregister(listener);
            return;
        }
        Object handledInstance = function.apply(event);
        for (BiPredicate<MergedSubscription<HelperMergedEventListener>, HelperMergedEventListener> biPredicate : this.preExpiryTests) {
            if (!biPredicate.test(this, (HelperMergedEventListener)handledInstance)) continue;
            event.getHandlers().unregister(listener);
            this.active.set(false);
            return;
        }
        try (MCTiming mCTiming = this.timing.startTiming();){
            for (Predicate predicate : this.filters) {
                if (predicate.test(handledInstance)) continue;
                return;
            }
            for (BiPredicate<MergedSubscription<T>, T> biPredicate : this.midExpiryTests) {
                if (!biPredicate.test(this, handledInstance)) continue;
                event.getHandlers().unregister(listener);
                this.active.set(false);
                return;
            }
            for (BiConsumer<MergedSubscription<T>, ? super T> biConsumer : this.handlers) {
                biConsumer.accept(this, (T)handledInstance);
            }
            this.callCount.incrementAndGet();
        }
        catch (Throwable throwable) {
            this.exceptionConsumer.accept(event, throwable);
        }
        for (BiPredicate<MergedSubscription<HelperMergedEventListener>, HelperMergedEventListener> biPredicate : this.postExpiryTests) {
            if (!biPredicate.test(this, (HelperMergedEventListener)handledInstance)) continue;
            event.getHandlers().unregister(listener);
            this.active.set(false);
            return;
        }
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }

    @Override
    public boolean isClosed() {
        return !this.active.get();
    }

    @Override
    public long getCallCounter() {
        return this.callCount.get();
    }

    @Override
    public boolean unregister() {
        if (!this.active.getAndSet(false)) {
            return false;
        }
        for (Class<? extends Event> clazz : this.mappings.keySet()) {
            HelperMergedEventListener.unregisterListener(clazz, this);
        }
        return true;
    }

    @Override
    @Nonnull
    public Class<? super T> getHandledClass() {
        return this.handledClass.getRawType();
    }

    @Override
    @Nonnull
    public Set<Class<? extends Event>> getEventClasses() {
        return this.mappings.keySet();
    }

    private static void unregisterListener(Class<? extends Event> eventClass, Listener listener) {
        try {
            Method getHandlerListMethod = eventClass.getMethod("getHandlerList", new Class[0]);
            HandlerList handlerList = (HandlerList)getHandlerListMethod.invoke(null, new Object[0]);
            handlerList.unregister(listener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

