/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.cooldown;

import com.google.gson.JsonElement;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import me.lucko.helper.cooldown.Cooldown;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.utils.TimeUtil;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
class CooldownImpl
implements LongSupplier,
Cooldown {
    private long lastTested;
    private final long timeout;

    CooldownImpl(long amount, TimeUnit unit) {
        this.timeout = unit.toMillis(amount);
        this.lastTested = 0L;
    }

    @Override
    public boolean test() {
        if (!this.testSilently()) {
            return false;
        }
        this.reset();
        return true;
    }

    @Override
    public boolean testSilently() {
        return this.elapsed() > this.timeout;
    }

    @Override
    public long elapsed() {
        return TimeUtil.now() - this.lastTested;
    }

    @Override
    public void reset() {
        this.lastTested = TimeUtil.now();
    }

    @Override
    public long remainingMillis() {
        long diff = this.elapsed();
        return diff > this.timeout ? 0L : this.timeout - diff;
    }

    @Override
    public long remainingTime(TimeUnit unit) {
        return Math.max(0L, unit.convert(this.remainingMillis(), TimeUnit.MILLISECONDS));
    }

    @Override
    public long getAsLong() {
        return this.remainingMillis();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public CooldownImpl copy() {
        return new CooldownImpl(this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public OptionalLong getLastTested() {
        return this.lastTested == 0L ? OptionalLong.empty() : OptionalLong.of(this.lastTested);
    }

    @Override
    public void setLastTested(long time) {
        this.lastTested = time <= 0L ? 0L : time;
    }

    @Override
    @Nonnull
    public JsonElement serialize() {
        return JsonBuilder.object().add("lastTested", this.lastTested).add("timeout", this.timeout).build();
    }
}

