/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.yaml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.ConfigurationOptions;
import me.lucko.helper.config.SimpleConfigurationNode;
import me.lucko.helper.config.loader.AbstractConfigurationLoader;
import me.lucko.helper.config.loader.CommentHandler;
import me.lucko.helper.config.loader.CommentHandlers;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YAMLConfigurationLoader
extends AbstractConfigurationLoader<ConfigurationNode> {
    private final ThreadLocal<Yaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YAMLConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.HASH});
        final DumperOptions opts = builder.options;
        this.yaml = new ThreadLocal<Yaml>(){

            @Override
            protected Yaml initialValue() {
                return new Yaml(opts);
            }
        };
    }

    @Override
    protected void loadInternal(ConfigurationNode node, BufferedReader reader) throws IOException {
        node.setValue(this.yaml.get().load((Reader)reader));
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        this.yaml.get().dump(node.getValue(), writer);
    }

    @Override
    public ConfigurationNode createEmptyNode(ConfigurationOptions options) {
        return SimpleConfigurationNode.root(options);
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private final DumperOptions options = new DumperOptions();

        protected Builder() {
            this.setIndent(4);
        }

        public Builder setIndent(int indent) {
            this.options.setIndent(indent);
            return this;
        }

        public Builder setFlowStyle(DumperOptions.FlowStyle style) {
            this.options.setDefaultFlowStyle(style);
            return this;
        }

        @Override
        public YAMLConfigurationLoader build() {
            return new YAMLConfigurationLoader(this);
        }
    }
}

