/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.transformation;

import java.util.Map;
import java.util.SortedMap;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.transformation.ConfigurationTransformation;

class VersionedTransformation
extends ConfigurationTransformation {
    private final Object[] versionPath;
    private final SortedMap<Integer, ConfigurationTransformation> versionTransformations;

    VersionedTransformation(Object[] versionPath, SortedMap<Integer, ConfigurationTransformation> versionTransformations) {
        this.versionPath = versionPath;
        this.versionTransformations = versionTransformations;
    }

    @Override
    public void apply(ConfigurationNode node) {
        ConfigurationNode versionNode = node.getNode(this.versionPath);
        int currentVersion = versionNode.getInt(-1);
        for (Map.Entry<Integer, ConfigurationTransformation> entry : this.versionTransformations.entrySet()) {
            if (entry.getKey() <= currentVersion) continue;
            entry.getValue().apply(node);
            currentVersion = entry.getKey();
        }
        versionNode.setValue(currentVersion);
    }
}

