/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.transformation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.transformation.ConfigurationTransformation;
import me.lucko.helper.config.transformation.MoveStrategy;
import me.lucko.helper.config.transformation.TransformAction;

class SingleConfigurationTransformation
extends ConfigurationTransformation {
    private final MoveStrategy strategy;
    private final Map<Object[], TransformAction> actions;
    private final ThreadLocal<ConfigurationTransformation.NodePath> sharedPath = new ThreadLocal<ConfigurationTransformation.NodePath>(){

        @Override
        protected ConfigurationTransformation.NodePath initialValue() {
            return new ConfigurationTransformation.NodePath();
        }
    };

    protected SingleConfigurationTransformation(Map<Object[], TransformAction> actions, MoveStrategy strategy) {
        this.actions = actions;
        this.strategy = strategy;
    }

    public static ConfigurationTransformation.Builder builder() {
        return new ConfigurationTransformation.Builder();
    }

    @Override
    public void apply(ConfigurationNode node) {
        for (Map.Entry<Object[], TransformAction> ent : this.actions.entrySet()) {
            this.applySingleAction(node, ent.getKey(), 0, node, ent.getValue());
        }
    }

    protected void applySingleAction(ConfigurationNode start, Object[] path, int startIdx, ConfigurationNode node, TransformAction action) {
        for (int i = startIdx; i < path.length; ++i) {
            if (path[i] == WILDCARD_OBJECT) {
                if (node.hasListChildren()) {
                    List<? extends ConfigurationNode> children = node.getChildrenList();
                    for (int cI = 0; cI < children.size(); ++cI) {
                        path[i] = cI;
                        this.applySingleAction(start, path, i + 1, children.get(cI), action);
                    }
                    path[i] = WILDCARD_OBJECT;
                } else if (node.hasMapChildren()) {
                    for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.getChildrenMap().entrySet()) {
                        path[i] = ent.getKey();
                        this.applySingleAction(start, path, i + 1, ent.getValue(), action);
                    }
                    path[i] = WILDCARD_OBJECT;
                } else {
                    return;
                }
                return;
            }
            if (!(node = node.getNode(path[i])).isVirtual()) continue;
            return;
        }
        ConfigurationTransformation.NodePath immutablePath = this.sharedPath.get();
        immutablePath.arr = path;
        Object[] transformedPath = action.visitPath(immutablePath, node);
        if (transformedPath != null && !Arrays.equals(path, transformedPath)) {
            this.strategy.move(node, start.getNode(transformedPath));
            node.setValue(null);
        }
    }
}

