/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import me.lucko.helper.config.objectmapping.DefaultObjectMapperFactory;
import me.lucko.helper.config.objectmapping.ObjectMapperFactory;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializerCollection;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializers;
import me.lucko.helper.config.util.MapFactories;
import me.lucko.helper.config.util.MapFactory;

public class ConfigurationOptions {
    private final MapFactory mapSupplier;
    private final String header;
    private final TypeSerializerCollection serializers;
    private final ImmutableSet<Class<?>> acceptedTypes;
    private final ObjectMapperFactory objectMapperFactory;
    private final boolean shouldCopyDefaults;

    private ConfigurationOptions(MapFactory mapSupplier, String header, TypeSerializerCollection serializers, Set<Class<?>> acceptedTypes, ObjectMapperFactory objectMapperFactory, boolean shouldCopyDefaults) {
        this.mapSupplier = mapSupplier;
        this.header = header;
        this.serializers = serializers;
        this.acceptedTypes = acceptedTypes == null ? null : ImmutableSet.copyOf(acceptedTypes);
        this.objectMapperFactory = objectMapperFactory;
        this.shouldCopyDefaults = shouldCopyDefaults;
    }

    public static ConfigurationOptions defaults() {
        return new ConfigurationOptions(MapFactories.insertionOrdered(), null, TypeSerializers.getDefaultSerializers(), null, DefaultObjectMapperFactory.getInstance(), false);
    }

    public MapFactory getMapFactory() {
        return this.mapSupplier;
    }

    public ConfigurationOptions setMapFactory(MapFactory factory) {
        Preconditions.checkNotNull((Object)factory, (Object)"factory");
        return new ConfigurationOptions(factory, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public String getHeader() {
        return this.header;
    }

    public ConfigurationOptions setHeader(String header) {
        return new ConfigurationOptions(this.mapSupplier, header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public TypeSerializerCollection getSerializers() {
        return this.serializers;
    }

    public ConfigurationOptions setSerializers(TypeSerializerCollection serializers) {
        return new ConfigurationOptions(this.mapSupplier, this.header, serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    public ConfigurationOptions setObjectMapperFactory(ObjectMapperFactory factory) {
        Preconditions.checkNotNull((Object)factory, (Object)"factory");
        return new ConfigurationOptions(this.mapSupplier, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, factory, this.shouldCopyDefaults);
    }

    public boolean acceptsType(Class<?> type) {
        if (this.acceptedTypes == null) {
            return true;
        }
        if (this.acceptedTypes.contains(type)) {
            return true;
        }
        for (Class clazz : this.acceptedTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public ConfigurationOptions setAcceptedTypes(Set<Class<?>> acceptedTypes) {
        return new ConfigurationOptions(this.mapSupplier, this.header, this.serializers, acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public boolean shouldCopyDefaults() {
        return this.shouldCopyDefaults;
    }

    public ConfigurationOptions setShouldCopyDefaults(boolean shouldCopyDefaults) {
        return new ConfigurationOptions(this.mapSupplier, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, shouldCopyDefaults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationOptions)) {
            return false;
        }
        ConfigurationOptions that = (ConfigurationOptions)o;
        return Objects.equal((Object)this.shouldCopyDefaults, (Object)that.shouldCopyDefaults) && Objects.equal((Object)this.mapSupplier, (Object)that.mapSupplier) && Objects.equal((Object)this.header, (Object)that.header) && Objects.equal((Object)this.serializers, (Object)that.serializers) && Objects.equal(this.acceptedTypes, that.acceptedTypes) && Objects.equal((Object)this.objectMapperFactory, (Object)that.objectMapperFactory);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mapSupplier, this.header, this.serializers, this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults});
    }
}

