/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import me.lucko.helper.config.ConfigurationOptions;
import me.lucko.helper.config.Types;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;

public interface ConfigurationNode {
    public static final int NUMBER_DEF = 0;

    public Object getKey();

    public Object[] getPath();

    public ConfigurationNode getParent();

    public ConfigurationOptions getOptions();

    default public Object getValue() {
        return this.getValue((Object)null);
    }

    public Object getValue(Object var1);

    public Object getValue(Supplier<Object> var1);

    default public <T> T getValue(Function<Object, T> transformer) {
        return this.getValue(transformer, (T)null);
    }

    public <T> T getValue(Function<Object, T> var1, T var2);

    public <T> T getValue(Function<Object, T> var1, Supplier<T> var2);

    public <T> List<T> getList(Function<Object, T> var1);

    public <T> List<T> getList(Function<Object, T> var1, List<T> var2);

    public <T> List<T> getList(Function<Object, T> var1, Supplier<List<T>> var2);

    default public <T> List<T> getList(TypeToken<T> type) throws ObjectMappingException {
        return this.getList(type, (List<T>)ImmutableList.of());
    }

    public <T> List<T> getList(TypeToken<T> var1, List<T> var2) throws ObjectMappingException;

    public <T> List<T> getList(TypeToken<T> var1, Supplier<List<T>> var2) throws ObjectMappingException;

    default public String getString() {
        return this.getString(null);
    }

    default public String getString(String def) {
        return this.getValue(Types::asString, def);
    }

    default public float getFloat() {
        return this.getFloat(0.0f);
    }

    default public float getFloat(float def) {
        return this.getValue(Types::asFloat, Float.valueOf(def)).floatValue();
    }

    default public double getDouble() {
        return this.getDouble(0.0);
    }

    default public double getDouble(double def) {
        return this.getValue(Types::asDouble, Double.valueOf(def));
    }

    default public int getInt() {
        return this.getInt(0);
    }

    default public int getInt(int def) {
        return this.getValue(Types::asInt, Integer.valueOf(def));
    }

    default public long getLong() {
        return this.getLong(0L);
    }

    default public long getLong(long def) {
        return this.getValue(Types::asLong, Long.valueOf(def));
    }

    default public boolean getBoolean() {
        return this.getBoolean(false);
    }

    default public boolean getBoolean(boolean def) {
        return this.getValue(Types::asBoolean, Boolean.valueOf(def));
    }

    public ConfigurationNode setValue(Object var1);

    default public <T> T getValue(TypeToken<T> type) throws ObjectMappingException {
        return this.getValue(type, (T)null);
    }

    public <T> T getValue(TypeToken<T> var1, T var2) throws ObjectMappingException;

    public <T> T getValue(TypeToken<T> var1, Supplier<T> var2) throws ObjectMappingException;

    default public <T> ConfigurationNode setValue(TypeToken<T> type, T value) throws ObjectMappingException {
        if (value == null) {
            this.setValue(null);
            return this;
        }
        TypeSerializer<T> serial = this.getOptions().getSerializers().get(type);
        if (serial != null) {
            serial.serialize(type, value, this);
        } else if (this.getOptions().acceptsType(value.getClass())) {
            this.setValue(value);
        } else {
            throw new ObjectMappingException("No serializer available for type " + type);
        }
        return this;
    }

    public ConfigurationNode mergeValuesFrom(ConfigurationNode var1);

    public boolean hasListChildren();

    public boolean hasMapChildren();

    public List<? extends ConfigurationNode> getChildrenList();

    public Map<Object, ? extends ConfigurationNode> getChildrenMap();

    public boolean removeChild(Object var1);

    public ConfigurationNode getAppendedNode();

    public ConfigurationNode getNode(Object ... var1);

    public boolean isVirtual();
}

