/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.commented.CommentedConfigurationNode;
import me.lucko.helper.config.gson.GsonConfigurationLoader;
import me.lucko.helper.config.hocon.HoconConfigurationLoader;
import me.lucko.helper.config.objectmapping.ObjectMapper;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.yaml.YAMLConfigurationLoader;
import org.yaml.snakeyaml.DumperOptions;

public final class Configs {
    @Nonnull
    public static YAMLConfigurationLoader yaml(@Nonnull Path path) {
        return ((YAMLConfigurationLoader.Builder)((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setFlowStyle(DumperOptions.FlowStyle.BLOCK).setIndent(2).setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]))).build();
    }

    @Nonnull
    public static ConfigurationNode yamlLoad(@Nonnull Path path) {
        try {
            return Configs.yaml(path).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void yamlSave(@Nonnull Path path, @Nonnull ConfigurationNode node) {
        try {
            Configs.yaml(path).save(node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static YAMLConfigurationLoader yaml(@Nonnull File file) {
        Path path = file.toPath();
        return ((YAMLConfigurationLoader.Builder)((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setFlowStyle(DumperOptions.FlowStyle.BLOCK).setIndent(2).setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]))).build();
    }

    @Nonnull
    public static ConfigurationNode yamlLoad(@Nonnull File file) {
        try {
            return Configs.yaml(file).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void yamlSave(@Nonnull File file, @Nonnull ConfigurationNode node) {
        try {
            Configs.yaml(file).save(node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static GsonConfigurationLoader gson(@Nonnull Path path) {
        return ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setIndent(2).setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]))).build();
    }

    @Nonnull
    public static ConfigurationNode gsonLoad(@Nonnull Path path) {
        try {
            return Configs.gson(path).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void gsonSave(@Nonnull Path path, @Nonnull ConfigurationNode node) {
        try {
            Configs.gson(path).save(node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static GsonConfigurationLoader gson(@Nonnull File file) {
        Path path = file.toPath();
        return ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)GsonConfigurationLoader.builder().setIndent(2).setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]))).build();
    }

    @Nonnull
    public static ConfigurationNode gsonLoad(@Nonnull File file) {
        try {
            return Configs.gson(file).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void gsonSave(@Nonnull File file, @Nonnull ConfigurationNode node) {
        try {
            Configs.gson(file).save(node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static HoconConfigurationLoader hocon(@Nonnull Path path) {
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]))).build();
    }

    @Nonnull
    public static CommentedConfigurationNode hoconLoad(@Nonnull Path path) {
        try {
            return (CommentedConfigurationNode)Configs.hocon(path).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void hoconSave(@Nonnull Path path, @Nonnull ConfigurationNode node) {
        try {
            Configs.hocon(path).save(node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static HoconConfigurationLoader hocon(@Nonnull File file) {
        Path path = file.toPath();
        return ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setSource(() -> Files.newBufferedReader(path, StandardCharsets.UTF_8))).setSink(() -> Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]))).build();
    }

    @Nonnull
    public static CommentedConfigurationNode hoconLoad(@Nonnull File file) {
        try {
            return (CommentedConfigurationNode)Configs.hocon(file).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void hoconSave(@Nonnull File file, @Nonnull ConfigurationNode node) {
        try {
            Configs.hocon(file).save(node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static <T> ObjectMapper<T> classMapper(@Nonnull Class<T> clazz) {
        try {
            return ObjectMapper.forClass(clazz);
        }
        catch (ObjectMappingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static <T> ObjectMapper.BoundInstance objectMapper(@Nonnull T object) {
        try {
            return ObjectMapper.forObject(object);
        }
        catch (ObjectMappingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static <T> T generate(@Nonnull Class<T> clazz, @Nonnull ConfigurationNode node) {
        try {
            return ObjectMapper.forClass(clazz).bindToNew().populate(node);
        }
        catch (ObjectMappingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static <T> T populate(@Nonnull T object, @Nonnull ConfigurationNode node) {
        try {
            return Configs.objectMapper(object).populate(node);
        }
        catch (ObjectMappingException e) {
            throw new RuntimeException(e);
        }
    }

    private Configs() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

