/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.cache;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import me.lucko.helper.utils.NullableOptional;

public final class Cache<T>
implements Supplier<T> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Supplier<T> supplier;
    private T value;
    private boolean hasValue = false;

    public static <T> Cache<T> suppliedBy(Supplier<T> supplier) {
        return new Cache<T>((Supplier)Preconditions.checkNotNull(supplier, (Object)"supplier"));
    }

    private Cache(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        this.lock.readLock().lock();
        try {
            if (this.hasValue) {
                T t = this.value;
                return t;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.hasValue) {
                T t = this.value;
                return t;
            }
            T t = this.value = this.supplier.get();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public NullableOptional<T> getIfPresent() {
        this.lock.readLock().lock();
        try {
            NullableOptional nullableOptional = this.hasValue ? NullableOptional.of(this.value) : NullableOptional.empty();
            return nullableOptional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void invalidate() {
        this.lock.writeLock().lock();
        try {
            this.hasValue = false;
            this.value = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

