/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import me.lucko.helper.Helper;
import me.lucko.helper.interfaces.Delegate;
import me.lucko.helper.internal.LoaderUtils;
import me.lucko.helper.promise.Promise;
import me.lucko.helper.promise.ThreadContext;
import me.lucko.helper.scheduler.HelperExecutors;
import me.lucko.helper.scheduler.Scheduler;
import me.lucko.helper.scheduler.Task;
import me.lucko.helper.scheduler.builder.TaskBuilder;
import me.lucko.helper.timings.MCTiming;
import me.lucko.helper.timings.Timings;
import me.lucko.helper.utils.Delegates;
import me.lucko.helper.utils.Log;
import me.lucko.helper.utils.annotation.NonnullByDefault;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;

@NonnullByDefault
public final class Schedulers {
    private static final Scheduler SYNC_SCHEDULER = new SyncScheduler();
    private static final Scheduler ASYNC_SCHEDULER = new AsyncScheduler();

    public static Scheduler get(ThreadContext context) {
        switch (context) {
            case SYNC: {
                return Schedulers.sync();
            }
            case ASYNC: {
                return Schedulers.async();
            }
        }
        throw new AssertionError();
    }

    public static Scheduler sync() {
        return SYNC_SCHEDULER;
    }

    public static Scheduler async() {
        return ASYNC_SCHEDULER;
    }

    public static BukkitScheduler bukkit() {
        return Helper.bukkitScheduler();
    }

    public static TaskBuilder builder() {
        return TaskBuilder.newBuilder();
    }

    private Schedulers() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static class HelperTask
    extends BukkitRunnable
    implements Task {
        private final Consumer<Task> backingTask;
        private final MCTiming timing;
        private final AtomicInteger counter = new AtomicInteger(0);
        private final AtomicBoolean shouldStop = new AtomicBoolean(false);

        private HelperTask(Consumer<Task> backingTask) {
            this.backingTask = backingTask;
            this.timing = Timings.of("helper-scheduler: " + Delegate.resolve(backingTask).getClass().getName());
        }

        public void run() {
            if (this.shouldStop.get()) {
                this.cancel();
                return;
            }
            try (MCTiming t = this.timing.startTiming();){
                this.backingTask.accept(this);
                this.counter.incrementAndGet();
            }
            catch (Throwable e) {
                Log.severe("[SCHEDULER] Exception thrown whilst executing task");
                e.printStackTrace();
            }
            if (this.shouldStop.get()) {
                this.cancel();
            }
        }

        @Override
        public int getTimesRan() {
            return this.counter.get();
        }

        @Override
        public boolean stop() {
            return !this.shouldStop.getAndSet(true);
        }

        @Override
        public int getBukkitId() {
            return this.getTaskId();
        }

        @Override
        public boolean isClosed() {
            return this.shouldStop.get();
        }
    }

    private static final class AsyncScheduler
    implements Scheduler {
        private AsyncScheduler() {
        }

        @Override
        public void execute(Runnable runnable) {
            HelperExecutors.asyncHelper().execute(runnable);
        }

        @Override
        @Nonnull
        public ThreadContext getContext() {
            return ThreadContext.ASYNC;
        }

        @Override
        @Nonnull
        public <T> Promise<T> supply(@Nonnull Supplier<T> supplier) {
            Preconditions.checkNotNull(supplier, (Object)"supplier");
            return Promise.supplyingAsync(supplier);
        }

        @Override
        @Nonnull
        public <T> Promise<T> call(@Nonnull Callable<T> callable) {
            Preconditions.checkNotNull(callable, (Object)"callable");
            return Promise.supplyingAsync(Delegates.callableToSupplier(callable));
        }

        @Override
        @Nonnull
        public Promise<Void> run(@Nonnull Runnable runnable) {
            Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
            return Promise.supplyingAsync(Delegates.runnableToSupplier(runnable));
        }

        @Override
        @Nonnull
        public <T> Promise<T> supplyLater(@Nonnull Supplier<T> supplier, long delay) {
            Preconditions.checkNotNull(supplier, (Object)"supplier");
            return Promise.supplyingDelayedAsync(supplier, delay);
        }

        @Override
        @Nonnull
        public <T> Promise<T> callLater(@Nonnull Callable<T> callable, long delay) {
            Preconditions.checkNotNull(callable, (Object)"callable");
            return Promise.supplyingDelayedAsync(Delegates.callableToSupplier(callable), delay);
        }

        @Override
        @Nonnull
        public Promise<Void> runLater(@Nonnull Runnable runnable, long delay) {
            Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
            return Promise.supplyingDelayedAsync(Delegates.runnableToSupplier(runnable), delay);
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delay, long interval) {
            Preconditions.checkNotNull(consumer, (Object)"consumer");
            Preconditions.checkNotNull(consumer, (Object)"consumer");
            HelperTask task = new HelperTask(consumer);
            task.runTaskTimerAsynchronously(LoaderUtils.getPlugin(), delay, interval);
            return task;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Runnable runnable, long delay, long interval) {
            Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
            return this.runRepeating(Delegates.runnableToConsumer(runnable), delay, interval);
        }
    }

    private static final class SyncScheduler
    implements Scheduler {
        private SyncScheduler() {
        }

        @Override
        public void execute(Runnable runnable) {
            HelperExecutors.sync().execute(runnable);
        }

        @Override
        @Nonnull
        public ThreadContext getContext() {
            return ThreadContext.SYNC;
        }

        @Override
        @Nonnull
        public <T> Promise<T> supply(@Nonnull Supplier<T> supplier) {
            Preconditions.checkNotNull(supplier, (Object)"supplier");
            return Promise.supplyingSync(supplier);
        }

        @Override
        @Nonnull
        public <T> Promise<T> call(@Nonnull Callable<T> callable) {
            Preconditions.checkNotNull(callable, (Object)"callable");
            return Promise.supplyingSync(Delegates.callableToSupplier(callable));
        }

        @Override
        @Nonnull
        public Promise<Void> run(@Nonnull Runnable runnable) {
            Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
            return Promise.supplyingSync(Delegates.runnableToSupplier(runnable));
        }

        @Override
        @Nonnull
        public <T> Promise<T> supplyLater(@Nonnull Supplier<T> supplier, long delay) {
            Preconditions.checkNotNull(supplier, (Object)"supplier");
            return Promise.supplyingDelayedSync(supplier, delay);
        }

        @Override
        @Nonnull
        public <T> Promise<T> callLater(@Nonnull Callable<T> callable, long delay) {
            Preconditions.checkNotNull(callable, (Object)"callable");
            return Promise.supplyingDelayedSync(Delegates.callableToSupplier(callable), delay);
        }

        @Override
        @Nonnull
        public Promise<Void> runLater(@Nonnull Runnable runnable, long delay) {
            Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
            return Promise.supplyingDelayedSync(Delegates.runnableToSupplier(runnable), delay);
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Consumer<Task> consumer, long delay, long interval) {
            Preconditions.checkNotNull(consumer, (Object)"consumer");
            HelperTask task = new HelperTask(consumer);
            task.runTaskTimer(LoaderUtils.getPlugin(), delay, interval);
            return task;
        }

        @Override
        @Nonnull
        public Task runRepeating(@Nonnull Runnable runnable, long delay, long interval) {
            Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
            return this.runRepeating(Delegates.runnableToConsumer(runnable), delay, interval);
        }
    }
}

