/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.utils;

import javax.annotation.Nonnull;
import org.bukkit.Bukkit;

public final class NmsUtil {
    public static final String NMS = "net.minecraft.server";
    public static final String OBC = "org.bukkit.craftbukkit";
    private static final String SERVER_VERSION;
    private static final String SERVER_VERSION_PACKAGE_COMPONENT;
    private static final String NMS_PREFIX;
    private static final String OBC_PREFIX;

    @Nonnull
    public static String getServerVersion() {
        return SERVER_VERSION;
    }

    @Nonnull
    public static String nms(String className) {
        return NMS_PREFIX.concat(className);
    }

    @Nonnull
    public static Class<?> nmsClass(String className) throws ClassNotFoundException {
        return Class.forName(NmsUtil.nms(className));
    }

    @Nonnull
    public static String obc(String className) {
        return OBC_PREFIX.concat(className);
    }

    @Nonnull
    public static Class<?> obcClass(String className) throws ClassNotFoundException {
        return Class.forName(NmsUtil.obc(className));
    }

    private NmsUtil() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    static {
        String obcPackage;
        String serverVersion = "";
        Class<?> server = Bukkit.getServer().getClass();
        if (server.getSimpleName().equals("CraftServer") && !server.getName().equals("org.bukkit.craftbukkit.CraftServer") && (obcPackage = server.getPackage().getName()).startsWith("org.bukkit.craftbukkit.")) {
            serverVersion = obcPackage.substring("org.bukkit.craftbukkit.".length());
        }
        SERVER_VERSION_PACKAGE_COMPONENT = (SERVER_VERSION = serverVersion).isEmpty() ? "." : "." + SERVER_VERSION + ".";
        NMS_PREFIX = NMS + SERVER_VERSION_PACKAGE_COMPONENT;
        OBC_PREFIX = OBC + SERVER_VERSION_PACKAGE_COMPONENT;
    }
}

