/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.utils;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@NonnullByDefault
public final class ImmutableCollectors {
    private static final Collector<Object, ImmutableList.Builder<Object>, ImmutableList<Object>> LIST = Collector.of(ImmutableList.Builder::new, ImmutableList.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableList.Builder::build, new Collector.Characteristics[0]);
    private static final Collector<Object, ImmutableSet.Builder<Object>, ImmutableSet<Object>> SET = Collector.of(ImmutableSet.Builder::new, ImmutableSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSet.Builder::build, new Collector.Characteristics[0]);

    public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toList() {
        return LIST;
    }

    public static <T> Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> toSet() {
        return SET;
    }

    public static <E> Collector<E, ?, ImmutableSortedSet<E>> toSortedSet(Comparator<? super E> comparator) {
        return Collector.of(() -> new ImmutableSortedSet.Builder(comparator), ImmutableSortedSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSortedSet.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ImmutableMap.Builder<K, V>, ImmutableMap<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(ImmutableMap.Builder::new, (r, t) -> r.put(keyMapper.apply(t), valueMapper.apply(t)), (l, r) -> l.putAll((Map)r.build()), ImmutableMap.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ?, ImmutableBiMap<K, V>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(ImmutableBiMap.Builder::new, (builder, input) -> builder.put(keyMapper.apply(input), valueMapper.apply(input)), (l, r) -> l.putAll((Map)r.build()), ImmutableBiMap.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ?, ImmutableSortedMap<K, V>> toSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(() -> new ImmutableSortedMap.Builder(comparator), (builder, input) -> builder.put(keyMapper.apply(input), valueMapper.apply(input)), (l, r) -> l.putAll((Map)r.build()), ImmutableSortedMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    private ImmutableCollectors() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

