/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.utils;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import me.lucko.helper.gson.JsonBuilder;
import me.lucko.helper.utils.Cooldown;
import me.lucko.helper.utils.annotation.NonnullByDefault;

@Deprecated
@NonnullByDefault
public class CooldownCollection<T> {
    protected final Cooldown base;
    protected final LoadingCache<String, Cooldown> cache;
    protected final Function<T, String> mappingFunc;

    @Deprecated
    public static CooldownCollection<String> create(Cooldown base) {
        Preconditions.checkNotNull((Object)base, (Object)"base");
        return new CooldownCollection<String>(s -> s, base);
    }

    @Deprecated
    public static <T> CooldownCollection<T> create(Function<T, String> mappingFunc, Cooldown base) {
        Preconditions.checkNotNull(mappingFunc, (Object)"mappingFunc");
        Preconditions.checkNotNull((Object)base, (Object)"base");
        return new CooldownCollection<T>(mappingFunc, base);
    }

    @Deprecated
    public static <T> CooldownCollection<T> createWithToString(Cooldown base) {
        Preconditions.checkNotNull((Object)base, (Object)"base");
        return new CooldownCollection<Object>(Object::toString, base);
    }

    private CooldownCollection(Function<T, String> mappingFunc, final Cooldown base) {
        this.base = base;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(base.getTimeout() + 10000L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, Cooldown>(){

            public Cooldown load(String s) {
                return base.copy();
            }
        });
        this.mappingFunc = mappingFunc;
    }

    public Cooldown get(T t) {
        return (Cooldown)this.cache.getUnchecked((Object)this.mappingFunc.apply(t));
    }

    public Map<String, Cooldown> getAll() {
        return this.cache.asMap();
    }

    public boolean test(T t) {
        return this.get(t).test();
    }

    public boolean testSilently(T t) {
        return this.get(t).testSilently();
    }

    public long elapsed(T t) {
        return this.get(t).elapsed();
    }

    public void reset(T t) {
        this.get(t).reset();
    }

    public long remainingMillis(T t) {
        return this.get(t).remainingMillis();
    }

    public long remainingTime(T t, TimeUnit unit) {
        return this.get(t).remainingTime(unit);
    }

    public void load(JsonObject data) {
        data.entrySet().forEach(e -> {
            Cooldown val = this.base.copy();
            val.setLastTested(((JsonElement)e.getValue()).getAsLong());
            this.cache.put(e.getKey(), (Object)val);
        });
    }

    public JsonObject save() {
        return this.cache.asMap().entrySet().stream().filter(e -> ((Cooldown)e.getValue()).getLastTested().isPresent()).collect(JsonBuilder.collectToObject(Map.Entry::getKey, s -> JsonBuilder.primitive(((Cooldown)s.getValue()).getLastTested().getAsLong())));
    }
}

