/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.lucko.helper.text.AbstractBuildableComponent;
import me.lucko.helper.text.Component;
import me.lucko.helper.text.event.ClickEvent;
import me.lucko.helper.text.event.HoverEvent;
import me.lucko.helper.text.format.TextColor;
import me.lucko.helper.text.format.TextDecoration;
import net.kyori.blizzard.NonNull;
import net.kyori.blizzard.Nullable;

public class TranslatableComponent
extends AbstractBuildableComponent<TranslatableComponent, Builder> {
    @NonNull
    private final String key;
    @NonNull
    private final List<Component> args;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NonNull String key) {
        return new Builder().key(key);
    }

    public static TranslatableComponent of(@NonNull String key) {
        return TranslatableComponent.builder(key).build();
    }

    public static TranslatableComponent of(@NonNull String key, Component ... args) {
        return TranslatableComponent.of(key, Arrays.asList(args));
    }

    public static TranslatableComponent of(@NonNull String key, @NonNull List<Component> args) {
        return TranslatableComponent.builder().key(key).args(args).build();
    }

    protected TranslatableComponent(@NonNull Builder builder) {
        super(builder);
        this.key = builder.key;
        this.args = ImmutableList.copyOf((Collection)builder.args);
    }

    protected TranslatableComponent(@NonNull List<Component> children, @Nullable TextColor color, @NonNull TextDecoration.State obfuscated, @NonNull TextDecoration.State bold, @NonNull TextDecoration.State strikethrough, @NonNull TextDecoration.State underlined, @NonNull TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion, @NonNull String key, @NonNull List<Component> args) {
        super(children, color, obfuscated, bold, strikethrough, underlined, italic, clickEvent, hoverEvent, insertion);
        this.key = key;
        this.args = ImmutableList.copyOf(args);
    }

    @NonNull
    public String key() {
        return this.key;
    }

    @NonNull
    public TranslatableComponent key(@NonNull String key) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, (String)Preconditions.checkNotNull((Object)key, (Object)"key"), this.args);
    }

    @NonNull
    public List<Component> args() {
        return Collections.unmodifiableList(this.args);
    }

    @NonNull
    public TranslatableComponent args(@NonNull List<Component> args) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, args);
    }

    @Override
    @NonNull
    public TranslatableComponent append(@NonNull Component component) {
        this.detectCycle(component);
        ArrayList<Component> children = new ArrayList<Component>(this.children.size() + 1);
        children.addAll(this.children);
        children.add(component);
        return new TranslatableComponent(children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent color(@Nullable TextColor color) {
        return new TranslatableComponent(this.children, color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (TranslatableComponent)super.decoration(decoration, flag);
    }

    @Override
    @NonNull
    public TranslatableComponent decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new TranslatableComponent(this.children, this.color, this.obfuscated, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
            case ITALIC: {
                return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
            case UNDERLINE: {
                return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
            case STRIKETHROUGH: {
                return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
            case OBFUSCATED: {
                return new TranslatableComponent(this.children, this.color, (TextDecoration.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"flag")), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    @Override
    @NonNull
    public TranslatableComponent clickEvent(@Nullable ClickEvent event) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent hoverEvent(@Nullable HoverEvent event) {
        if (event != null) {
            this.detectCycle(event.value());
        }
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent insertion(@Nullable String insertion) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent mergeStyle(@NonNull Component that) {
        return new TranslatableComponent(this.children, that.color(), that.decoration(TextDecoration.OBFUSCATED), that.decoration(TextDecoration.BOLD), that.decoration(TextDecoration.STRIKETHROUGH), that.decoration(TextDecoration.UNDERLINE), that.decoration(TextDecoration.ITALIC), that.clickEvent(), that.hoverEvent(), that.insertion(), this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent mergeColor(@NonNull Component that) {
        return new TranslatableComponent(this.children, that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent mergeDecorations(@NonNull Component that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINE) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINE) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new TranslatableComponent(this.children, this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent mergeEvents(@NonNull Component that) {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent resetStyle() {
        return new TranslatableComponent(this.children, null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null, this.key, this.args);
    }

    @Override
    @NonNull
    public TranslatableComponent copy() {
        return new TranslatableComponent(this.children, this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion, this.key, this.args);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof TranslatableComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TranslatableComponent that = (TranslatableComponent)other;
        return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal(this.args, that.args);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.key, this.args});
    }

    @Override
    protected void populateToString(@NonNull Objects.ToStringHelper builder) {
        builder.add("key", (Object)this.key).add("args", this.args);
    }

    @Override
    @NonNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends AbstractBuildableComponent.AbstractBuilder<TranslatableComponent, Builder> {
        @Nullable
        private String key;
        @NonNull
        private List<Component> args = Component.EMPTY_COMPONENT_LIST;

        Builder() {
        }

        Builder(@NonNull TranslatableComponent component) {
            super(component);
            this.key = component.key();
            this.args = component.args();
        }

        @NonNull
        public Builder key(@NonNull String key) {
            this.key = key;
            return this;
        }

        @NonNull
        public Builder args(Component ... args) {
            return this.args(Arrays.asList(args));
        }

        @NonNull
        public Builder args(@NonNull List<Component> args) {
            this.args = args;
            return this;
        }

        @Override
        @NonNull
        public TranslatableComponent build() {
            Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"key must be set");
            return new TranslatableComponent(this);
        }
    }
}

